/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterEvent;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateReason;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.NodeEvent;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class EventDiffCalculator {
    public static Params params() {
        return new Params();
    }

    public static List<Event> computeEventDiff(Params params) {
        ArrayList<Event> events = new ArrayList<Event>();
        EventDiffCalculator.emitPerNodeDiffEvents(EventDiffCalculator.createBaselineParams(params), events);
        EventDiffCalculator.emitWholeClusterDiffEvent(EventDiffCalculator.createBaselineParams(params), events);
        EventDiffCalculator.emitDerivedBucketSpaceStatesDiffEvents(params, events);
        return events;
    }

    private static PerStateParams createBaselineParams(Params params) {
        return new PerStateParams(params.cluster, Optional.empty(), params.fromState.getBaselineAnnotatedState(), params.toState.getBaselineAnnotatedState(), params.currentTime);
    }

    private static void emitWholeClusterDiffEvent(PerStateParams params, List<Event> events) {
        ClusterState toState;
        ClusterState fromState = params.fromState.getClusterState();
        if (EventDiffCalculator.clusterHasTransitionedToUpState(fromState, toState = params.toState.getClusterState())) {
            events.add(EventDiffCalculator.createClusterEvent("Enough nodes available for system to become up", params));
        } else if (EventDiffCalculator.clusterHasTransitionedToDownState(fromState, toState)) {
            if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_FEW_STORAGE_NODES_AVAILABLE)) {
                events.add(EventDiffCalculator.createClusterEvent("Too few storage nodes available in cluster. Setting cluster state down", params));
            } else if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_FEW_DISTRIBUTOR_NODES_AVAILABLE)) {
                events.add(EventDiffCalculator.createClusterEvent("Too few distributor nodes available in cluster. Setting cluster state down", params));
            } else if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_LOW_AVAILABLE_STORAGE_NODE_RATIO)) {
                events.add(EventDiffCalculator.createClusterEvent("Too low ratio of available storage nodes. Setting cluster state down", params));
            } else if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_LOW_AVAILABLE_DISTRIBUTOR_NODE_RATIO)) {
                events.add(EventDiffCalculator.createClusterEvent("Too low ratio of available distributor nodes. Setting cluster state down", params));
            } else {
                events.add(EventDiffCalculator.createClusterEvent("Cluster is down", params));
            }
        }
    }

    private static ClusterEvent createClusterEvent(String description, PerStateParams params) {
        return new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, description, params.currentTime);
    }

    private static boolean clusterDownBecause(PerStateParams params, ClusterStateReason wantedReason) {
        Optional<ClusterStateReason> actualReason = params.toState.getClusterStateReason();
        return actualReason.isPresent() && actualReason.get().equals((Object)wantedReason);
    }

    private static void emitPerNodeDiffEvents(PerStateParams params, List<Event> events) {
        ContentCluster cluster = params.cluster;
        ClusterState fromState = params.fromState.getClusterState();
        ClusterState toState = params.toState.getClusterState();
        for (ConfiguredNode node : cluster.getConfiguredNodes().values()) {
            for (NodeType nodeType : NodeType.getTypes()) {
                Node n = new Node(nodeType, node.index());
                EventDiffCalculator.emitSingleNodeEvents(params, events, cluster, fromState, toState, n);
            }
        }
    }

    private static void emitSingleNodeEvents(PerStateParams params, List<Event> events, ContentCluster cluster, ClusterState fromState, ClusterState toState, Node n) {
        NodeState nodeFrom = fromState.getNodeState(n);
        NodeState nodeTo = toState.getNodeState(n);
        if (!nodeTo.equals((Object)nodeFrom)) {
            NodeInfo info = cluster.getNodeInfo(n);
            events.add(EventDiffCalculator.createNodeEvent(info, String.format("Altered node state in cluster state from '%s' to '%s'", nodeFrom.toString(true), nodeTo.toString(true)), params));
            NodeStateReason prevReason = params.fromState.getNodeStateReasons().get(n);
            NodeStateReason currReason = params.toState.getNodeStateReasons().get(n);
            if (EventDiffCalculator.isGroupDownEdge(prevReason, currReason)) {
                events.add(EventDiffCalculator.createNodeEvent(info, "Group node availability is below configured threshold", params));
            } else if (EventDiffCalculator.isGroupUpEdge(prevReason, currReason)) {
                events.add(EventDiffCalculator.createNodeEvent(info, "Group node availability has been restored", params));
            } else if (EventDiffCalculator.isMayHaveMergesPendingUpEdge(prevReason, currReason)) {
                events.add(EventDiffCalculator.createNodeEvent(info, "Node may have merges pending", params));
            } else if (EventDiffCalculator.isMayHaveMergesPendingDownEdge(prevReason, currReason)) {
                events.add(EventDiffCalculator.createNodeEvent(info, "Node no longer has merges pending", params));
            }
        }
    }

    private static NodeEvent createNodeEvent(NodeInfo nodeInfo, String description, PerStateParams params) {
        if (params.bucketSpace.isPresent()) {
            return NodeEvent.forBucketSpace(nodeInfo, params.bucketSpace.get(), description, NodeEvent.Type.CURRENT, params.currentTime);
        }
        return NodeEvent.forBaseline(nodeInfo, description, NodeEvent.Type.CURRENT, params.currentTime);
    }

    private static boolean isGroupUpEdge(NodeStateReason prevReason, NodeStateReason currReason) {
        return prevReason == NodeStateReason.GROUP_IS_DOWN && currReason != NodeStateReason.GROUP_IS_DOWN;
    }

    private static boolean isGroupDownEdge(NodeStateReason prevReason, NodeStateReason currReason) {
        return prevReason != NodeStateReason.GROUP_IS_DOWN && currReason == NodeStateReason.GROUP_IS_DOWN;
    }

    private static boolean isMayHaveMergesPendingUpEdge(NodeStateReason prevReason, NodeStateReason currReason) {
        return prevReason != NodeStateReason.MAY_HAVE_MERGES_PENDING && currReason == NodeStateReason.MAY_HAVE_MERGES_PENDING;
    }

    private static boolean isMayHaveMergesPendingDownEdge(NodeStateReason prevReason, NodeStateReason currReason) {
        return prevReason == NodeStateReason.MAY_HAVE_MERGES_PENDING && currReason != NodeStateReason.MAY_HAVE_MERGES_PENDING;
    }

    private static boolean clusterHasTransitionedToUpState(ClusterState prevState, ClusterState currentState) {
        return prevState.getClusterState() != State.UP && currentState.getClusterState() == State.UP;
    }

    private static boolean clusterHasTransitionedToDownState(ClusterState prevState, ClusterState currentState) {
        return prevState.getClusterState() != State.DOWN && currentState.getClusterState() == State.DOWN;
    }

    private static void emitDerivedBucketSpaceStatesDiffEvents(Params params, List<Event> events) {
        params.toState.getDerivedBucketSpaceStates().entrySet().forEach(toEntry -> {
            String toBucketSpace = (String)toEntry.getKey();
            AnnotatedClusterState toDerivedState = (AnnotatedClusterState)toEntry.getValue();
            AnnotatedClusterState fromDerivedState = params.fromState.getDerivedBucketSpaceStates().get(toBucketSpace);
            if (fromDerivedState != null && EventDiffCalculator.shouldConsiderDerivedStates(params, fromDerivedState, toDerivedState)) {
                EventDiffCalculator.emitPerNodeDiffEvents(EventDiffCalculator.createDerivedParams(params, toBucketSpace, fromDerivedState, toDerivedState), events);
            }
        });
    }

    private static boolean shouldConsiderDerivedStates(Params params, AnnotatedClusterState fromDerivedState, AnnotatedClusterState toDerivedState) {
        return !fromDerivedState.getClusterState().equals((Object)params.fromState.getBaselineClusterState()) || !toDerivedState.getClusterState().equals((Object)params.toState.getBaselineClusterState());
    }

    private static PerStateParams createDerivedParams(Params params, String bucketSpace, AnnotatedClusterState fromDerivedState, AnnotatedClusterState toDerivedState) {
        return new PerStateParams(params.cluster, Optional.of(bucketSpace), fromDerivedState, toDerivedState, params.currentTime);
    }

    private static class PerStateParams {
        final ContentCluster cluster;
        final Optional<String> bucketSpace;
        final AnnotatedClusterState fromState;
        final AnnotatedClusterState toState;
        final long currentTime;

        PerStateParams(ContentCluster cluster, Optional<String> bucketSpace, AnnotatedClusterState fromState, AnnotatedClusterState toState, long currentTime) {
            this.cluster = cluster;
            this.bucketSpace = bucketSpace;
            this.fromState = fromState;
            this.toState = toState;
            this.currentTime = currentTime;
        }
    }

    static class Params {
        ContentCluster cluster;
        ClusterStateBundle fromState;
        ClusterStateBundle toState;
        long currentTime;

        Params() {
        }

        public Params cluster(ContentCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Params fromState(ClusterStateBundle bundle) {
            this.fromState = bundle;
            return this;
        }

        public Params toState(ClusterStateBundle bundle) {
            this.toState = bundle;
            return this;
        }

        public Params currentTimeMs(long time) {
            this.currentTime = time;
            return this;
        }
    }
}

