/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.AggregatedStatsMergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClusterStatsChangeTracker {
    private AggregatedClusterStats aggregatedStats;
    private AggregatedStatsMergePendingChecker checker;
    private Map<Integer, Boolean> prevMayHaveMergesPending = null;

    public ClusterStatsChangeTracker(AggregatedClusterStats aggregatedStats) {
        this.setAggregatedStats(aggregatedStats);
    }

    private void setAggregatedStats(AggregatedClusterStats aggregatedStats) {
        this.aggregatedStats = aggregatedStats;
        this.checker = new AggregatedStatsMergePendingChecker(this.aggregatedStats);
    }

    public void syncAggregatedStats() {
        this.prevMayHaveMergesPending = new HashMap<Integer, Boolean>();
        Iterator<ContentNodeStats> itr = this.aggregatedStats.getStats().iterator();
        while (itr.hasNext()) {
            int nodeIndex = itr.next().getNodeIndex();
            this.prevMayHaveMergesPending.put(nodeIndex, this.mayHaveMergesPendingInGlobalSpace(nodeIndex));
        }
    }

    public void updateAggregatedStats(AggregatedClusterStats newAggregatedStats) {
        this.syncAggregatedStats();
        this.setAggregatedStats(newAggregatedStats);
    }

    public boolean statsHaveChanged() {
        if (!this.aggregatedStats.hasUpdatesFromAllDistributors()) {
            return false;
        }
        Iterator<ContentNodeStats> itr = this.aggregatedStats.getStats().iterator();
        while (itr.hasNext()) {
            int nodeIndex = itr.next().getNodeIndex();
            boolean currValue = this.mayHaveMergesPendingInGlobalSpace(nodeIndex);
            Boolean prevValue = this.prevMayHaveMergesPendingInGlobalSpace(nodeIndex);
            if (!(prevValue != null ? prevValue != currValue : currValue)) continue;
            return true;
        }
        return false;
    }

    private boolean mayHaveMergesPendingInGlobalSpace(int nodeIndex) {
        return this.checker.mayHaveMergesPending(FixedBucketSpaces.globalSpace(), nodeIndex);
    }

    private Boolean prevMayHaveMergesPendingInGlobalSpace(int nodeIndex) {
        if (this.prevMayHaveMergesPending != null) {
            return this.prevMayHaveMergesPending.get(nodeIndex);
        }
        return null;
    }
}

