/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.ClusterStateHistoryEntry;
import com.yahoo.vespa.clustercontroller.core.ClusterStateView;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsChangeTracker;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class StateVersionTracker {
    private int currentVersion = 1;
    private int lastZooKeeperVersion = 0;
    private int lowestObservedDistributionBits = 16;
    private ClusterStateBundle currentUnversionedState = ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.emptyState());
    private ClusterStateBundle latestCandidateState;
    private ClusterStateBundle currentClusterState = this.latestCandidateState = ClusterStateBundle.ofBaselineOnly(AnnotatedClusterState.emptyState());
    private ClusterStateView clusterStateView;
    private ClusterStatsChangeTracker clusterStatsChangeTracker;
    private final LinkedList<ClusterStateHistoryEntry> clusterStateHistory = new LinkedList();
    private int maxHistoryEntryCount = 50;

    StateVersionTracker() {
        this.clusterStateView = ClusterStateView.create(this.currentUnversionedState.getBaselineClusterState());
        this.clusterStatsChangeTracker = new ClusterStatsChangeTracker(this.clusterStateView.getStatsAggregator().getAggregatedStats());
    }

    void setVersionRetrievedFromZooKeeper(int version) {
        this.lastZooKeeperVersion = this.currentVersion = Math.max(1, version);
    }

    void setMaxHistoryEntryCount(int maxHistoryEntryCount) {
        this.maxHistoryEntryCount = maxHistoryEntryCount;
    }

    int getCurrentVersion() {
        return this.currentVersion;
    }

    boolean hasReceivedNewVersionFromZooKeeper() {
        return this.currentVersion <= this.lastZooKeeperVersion;
    }

    int getLowestObservedDistributionBits() {
        return this.lowestObservedDistributionBits;
    }

    AnnotatedClusterState getAnnotatedVersionedClusterState() {
        return this.currentClusterState.getBaselineAnnotatedState();
    }

    public ClusterState getVersionedClusterState() {
        return this.currentClusterState.getBaselineClusterState();
    }

    public ClusterStatsAggregator getAggregatedClusterStats() {
        return this.clusterStateView.getStatsAggregator();
    }

    public ClusterStateBundle getVersionedClusterStateBundle() {
        return this.currentClusterState;
    }

    public void updateLatestCandidateStateBundle(ClusterStateBundle candidateBundle) {
        assert (this.latestCandidateState.getBaselineClusterState().getVersion() == 0);
        this.latestCandidateState = candidateBundle;
        this.clusterStatsChangeTracker.syncBucketsPendingFlag();
    }

    public AnnotatedClusterState getLatestCandidateState() {
        return this.latestCandidateState.getBaselineAnnotatedState();
    }

    public List<ClusterStateHistoryEntry> getClusterStateHistory() {
        return Collections.unmodifiableList(this.clusterStateHistory);
    }

    boolean candidateChangedEnoughFromCurrentToWarrantPublish() {
        return !this.currentUnversionedState.similarTo(this.latestCandidateState);
    }

    void promoteCandidateToVersionedState(long currentTimeMs) {
        int newVersion = this.currentVersion + 1;
        this.updateStatesForNewVersion(this.latestCandidateState, newVersion);
        this.currentVersion = newVersion;
        this.recordCurrentStateInHistoryAtTime(currentTimeMs);
    }

    private void updateStatesForNewVersion(ClusterStateBundle newStateBundle, int newVersion) {
        this.currentClusterState = newStateBundle.clonedWithVersionSet(newVersion);
        this.currentUnversionedState = newStateBundle;
        this.lowestObservedDistributionBits = Math.min(this.lowestObservedDistributionBits, newStateBundle.getBaselineClusterState().getDistributionBitCount());
        this.clusterStateView = ClusterStateView.create(this.currentClusterState.getBaselineClusterState());
        this.clusterStatsChangeTracker.updateAggregatedStats(this.clusterStateView.getStatsAggregator().getAggregatedStats());
    }

    private void recordCurrentStateInHistoryAtTime(long currentTimeMs) {
        this.clusterStateHistory.addFirst(new ClusterStateHistoryEntry(this.currentClusterState.getBaselineClusterState(), currentTimeMs));
        while (this.clusterStateHistory.size() > this.maxHistoryEntryCount) {
            this.clusterStateHistory.removeLast();
        }
    }

    void handleUpdatedHostInfo(NodeInfo node, HostInfo hostInfo) {
        this.clusterStateView.handleUpdatedHostInfo(node, hostInfo);
    }

    boolean bucketSpaceMergeCompletionStateHasChanged() {
        return this.clusterStatsChangeTracker.statsHaveChanged();
    }

    MergePendingChecker createMergePendingChecker() {
        return this.clusterStateView.getStatsAggregator().createMergePendingChecker();
    }
}

