/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MaintenanceWhenPendingGlobalMerges
implements ClusterStateDeriver {
    private static final String bucketSpaceToCheck = FixedBucketSpaces.globalSpace();
    private static final String bucketSpaceToDerive = FixedBucketSpaces.defaultSpace();
    private final MergePendingChecker mergePendingChecker;

    public MaintenanceWhenPendingGlobalMerges(MergePendingChecker mergePendingChecker) {
        this.mergePendingChecker = mergePendingChecker;
    }

    @Override
    public AnnotatedClusterState derivedFrom(AnnotatedClusterState baselineState, String bucketSpace) {
        if (!bucketSpace.equals(bucketSpaceToDerive)) {
            return baselineState.clone();
        }
        Set<Integer> incompleteNodeIndices = this.nodesWithMergesNotDone(baselineState.getClusterState());
        if (incompleteNodeIndices.isEmpty()) {
            return baselineState.clone();
        }
        return this.setNodesInMaintenance(baselineState, incompleteNodeIndices);
    }

    private Set<Integer> nodesWithMergesNotDone(ClusterState baselineState) {
        HashSet<Integer> incompleteNodes = new HashSet<Integer>();
        int nodeCount = baselineState.getNodeCount(NodeType.STORAGE);
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            if (!this.contentNodeIsAvailable(baselineState, nodeIndex) || !this.mayHaveMergesPending(bucketSpaceToCheck, nodeIndex)) continue;
            incompleteNodes.add(nodeIndex);
        }
        return incompleteNodes;
    }

    private AnnotatedClusterState setNodesInMaintenance(AnnotatedClusterState baselineState, Set<Integer> incompleteNodeIndices) {
        ClusterState derivedState = baselineState.getClusterState().clone();
        HashMap<Node, NodeStateReason> nodeStateReasons = new HashMap<Node, NodeStateReason>(baselineState.getNodeStateReasons());
        incompleteNodeIndices.forEach(nodeIndex -> {
            Node node = Node.ofStorage((int)nodeIndex);
            derivedState.setNodeState(node, new NodeState(NodeType.STORAGE, State.MAINTENANCE));
            nodeStateReasons.put(node, NodeStateReason.MAY_HAVE_MERGES_PENDING);
        });
        return new AnnotatedClusterState(derivedState, baselineState.getClusterStateReason(), nodeStateReasons);
    }

    private boolean contentNodeIsAvailable(ClusterState state, int nodeIndex) {
        return state.getNodeState(Node.ofStorage((int)nodeIndex)).getState().oneOf("uir");
    }

    private boolean mayHaveMergesPending(String bucketSpace, int nodeIndex) {
        return this.mergePendingChecker.mayHaveMergesPending(bucketSpace, nodeIndex);
    }
}

