/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ClusterStateBundle {
    private final AnnotatedClusterState baselineState;
    private final Map<String, ClusterState> derivedBucketSpaceStates;

    private ClusterStateBundle(AnnotatedClusterState baselineState, Map<String, ClusterState> derivedBucketSpaceStates) {
        this.baselineState = baselineState;
        this.derivedBucketSpaceStates = Collections.unmodifiableMap(derivedBucketSpaceStates);
    }

    public static Builder builder(AnnotatedClusterState baselineState) {
        return new Builder(baselineState);
    }

    public static ClusterStateBundle of(AnnotatedClusterState baselineState, Map<String, ClusterState> derivedBucketSpaceStates) {
        return new ClusterStateBundle(baselineState, derivedBucketSpaceStates);
    }

    public static ClusterStateBundle ofBaselineOnly(AnnotatedClusterState baselineState) {
        return new ClusterStateBundle(baselineState, Collections.emptyMap());
    }

    public AnnotatedClusterState getBaselineAnnotatedState() {
        return this.baselineState;
    }

    public ClusterState getBaselineClusterState() {
        return this.baselineState.getClusterState();
    }

    public Map<String, ClusterState> getDerivedBucketSpaceStates() {
        return this.derivedBucketSpaceStates;
    }

    public ClusterStateBundle cloneWithMapper(Function<ClusterState, ClusterState> mapper) {
        AnnotatedClusterState clonedBaseline = new AnnotatedClusterState(mapper.apply(this.baselineState.getClusterState().clone()), this.baselineState.getClusterStateReason(), this.baselineState.getNodeStateReasons());
        Map<String, ClusterState> clonedDerived = this.derivedBucketSpaceStates.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (ClusterState)mapper.apply(((ClusterState)e.getValue()).clone())));
        return new ClusterStateBundle(clonedBaseline, clonedDerived);
    }

    public ClusterStateBundle clonedWithVersionSet(int version) {
        return this.cloneWithMapper(state -> {
            state.setVersion(version);
            return state;
        });
    }

    public boolean similarTo(ClusterStateBundle other) {
        if (!this.baselineState.getClusterState().similarToIgnoringInitProgress(other.baselineState.getClusterState())) {
            return false;
        }
        return this.derivedBucketSpaceStates.entrySet().stream().allMatch(entry -> other.derivedBucketSpaceStates.getOrDefault(entry.getKey(), (ClusterState)entry.getValue()).similarToIgnoringInitProgress((ClusterState)entry.getValue()));
    }

    public int getVersion() {
        return this.baselineState.getClusterState().getVersion();
    }

    public String toString() {
        if (this.derivedBucketSpaceStates.isEmpty()) {
            return String.format("ClusterStateBundle('%s')", this.baselineState);
        }
        TreeMap<String, ClusterState> orderedStates = new TreeMap<String, ClusterState>(this.derivedBucketSpaceStates);
        return String.format("ClusterStateBundle('%s', %s)", this.baselineState, orderedStates.entrySet().stream().map(e -> String.format("%s '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(", ")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateBundle that = (ClusterStateBundle)o;
        return Objects.equals(this.baselineState, that.baselineState) && Objects.equals(this.derivedBucketSpaceStates, that.derivedBucketSpaceStates);
    }

    public int hashCode() {
        return Objects.hash(this.baselineState, this.derivedBucketSpaceStates);
    }

    public static class Builder {
        private final AnnotatedClusterState baselineState;
        private ClusterStateDeriver stateDeriver;
        private Set<String> bucketSpaces;

        public Builder(AnnotatedClusterState baselineState) {
            this.baselineState = baselineState;
        }

        public Builder stateDeriver(ClusterStateDeriver stateDeriver) {
            this.stateDeriver = stateDeriver;
            return this;
        }

        public Builder bucketSpaces(Set<String> bucketSpaces) {
            this.bucketSpaces = bucketSpaces;
            return this;
        }

        public Builder bucketSpaces(String ... bucketSpaces) {
            this.bucketSpaces = new TreeSet<String>(Arrays.asList(bucketSpaces));
            return this;
        }

        public ClusterStateBundle deriveAndBuild() {
            if (this.stateDeriver == null || this.bucketSpaces == null || this.bucketSpaces.isEmpty()) {
                return ClusterStateBundle.ofBaselineOnly(this.baselineState);
            }
            Map derived = this.bucketSpaces.stream().collect(Collectors.toMap(Function.identity(), s -> this.stateDeriver.derivedFrom(this.baselineState.getClusterState(), (String)s)));
            return new ClusterStateBundle(this.baselineState, derived);
        }
    }
}

