/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vespa.clustercontroller.core.ClusterStateReason;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AnnotatedClusterState {
    private final ClusterState clusterState;
    private final Map<Node, NodeStateReason> nodeStateReasons;
    private final Optional<ClusterStateReason> clusterStateReason;

    public AnnotatedClusterState(ClusterState clusterState, Optional<ClusterStateReason> clusterStateReason, Map<Node, NodeStateReason> nodeStateReasons) {
        this.clusterState = clusterState;
        this.clusterStateReason = clusterStateReason;
        this.nodeStateReasons = nodeStateReasons;
    }

    public static AnnotatedClusterState emptyState() {
        return new AnnotatedClusterState(ClusterState.emptyState(), Optional.empty(), AnnotatedClusterState.emptyNodeStateReasons());
    }

    public static AnnotatedClusterState withoutAnnotations(ClusterState state) {
        return new AnnotatedClusterState(state, Optional.empty(), AnnotatedClusterState.emptyNodeStateReasons());
    }

    static Map<Node, NodeStateReason> emptyNodeStateReasons() {
        return Collections.emptyMap();
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Map<Node, NodeStateReason> getNodeStateReasons() {
        return Collections.unmodifiableMap(this.nodeStateReasons);
    }

    public Optional<ClusterStateReason> getClusterStateReason() {
        return this.clusterStateReason;
    }

    public String toString() {
        return this.clusterState.toString();
    }

    public String toString(boolean verbose) {
        return this.clusterState.toString(verbose);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedClusterState that = (AnnotatedClusterState)o;
        return Objects.equals(this.clusterState, that.clusterState) && Objects.equals(this.nodeStateReasons, that.nodeStateReasons) && Objects.equals(this.clusterStateReason, that.clusterStateReason);
    }

    public int hashCode() {
        return Objects.hash(this.clusterState, this.nodeStateReasons, this.clusterStateReason);
    }
}

