/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.yahoo.vespa.clustercontroller.core.ContentClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.LatencyStats;
import com.yahoo.vespa.clustercontroller.core.StorageNodeStats;
import com.yahoo.vespa.clustercontroller.core.StorageNodeStatsContainer;
import com.yahoo.vespa.clustercontroller.core.hostinfo.Distributor;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.StorageNode;
import java.util.HashMap;
import java.util.List;

public class StorageNodeStatsBridge {
    private StorageNodeStatsBridge() {
    }

    public static StorageNodeStatsContainer traverseHostInfo(HostInfo hostInfo) {
        StorageNodeStatsContainer container = new StorageNodeStatsContainer();
        List<StorageNode> storageNodes = hostInfo.getDistributor().getStorageNodes();
        for (StorageNode storageNode : storageNodes) {
            StorageNode.OpsLatency opsLatency;
            Integer storageNodeIndex = storageNode.getIndex();
            if (storageNodeIndex == null || (opsLatency = storageNode.getOpsLatenciesOrNull()) == null) continue;
            StorageNode.Put putLatency = opsLatency.getPut();
            Long putLatencyMsSum = putLatency.getLatencyMsSum();
            Long putLatencyCount = putLatency.getCount();
            if (putLatencyMsSum == null || putLatencyCount == null) continue;
            LatencyStats putLatencyStats = new LatencyStats(putLatencyMsSum, putLatencyCount);
            StorageNodeStats nodeStats = new StorageNodeStats(putLatencyStats);
            container.put(storageNodeIndex, nodeStats);
        }
        return container;
    }

    public static ContentClusterStats generate(Distributor distributor) {
        HashMap<Integer, ContentNodeStats> mapToNodeStats = new HashMap<Integer, ContentNodeStats>();
        for (StorageNode storageNode : distributor.getStorageNodes()) {
            mapToNodeStats.put(storageNode.getIndex(), new ContentNodeStats(storageNode));
        }
        return new ContentClusterStats(mapToNodeStats);
    }
}

