/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateHistoryEntry;
import com.yahoo.vespa.clustercontroller.core.ClusterStateView;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StateVersionTracker {
    private int currentVersion = 1;
    private int lastZooKeeperVersion = 0;
    private int lowestObservedDistributionBits = 16;
    private ClusterState currentUnversionedState = ClusterState.emptyState();
    private AnnotatedClusterState latestCandidateState;
    private AnnotatedClusterState currentClusterState = this.latestCandidateState = AnnotatedClusterState.emptyState();
    private ClusterStateView clusterStateView;
    private final LinkedList<ClusterStateHistoryEntry> clusterStateHistory = new LinkedList();
    private int maxHistoryEntryCount = 50;

    StateVersionTracker() {
        this.clusterStateView = ClusterStateView.create(this.currentUnversionedState);
    }

    void setVersionRetrievedFromZooKeeper(int version) {
        this.lastZooKeeperVersion = this.currentVersion = Math.max(1, version);
    }

    void setMaxHistoryEntryCount(int maxHistoryEntryCount) {
        this.maxHistoryEntryCount = maxHistoryEntryCount;
    }

    int getCurrentVersion() {
        return this.currentVersion;
    }

    boolean hasReceivedNewVersionFromZooKeeper() {
        return this.currentVersion <= this.lastZooKeeperVersion;
    }

    int getLowestObservedDistributionBits() {
        return this.lowestObservedDistributionBits;
    }

    AnnotatedClusterState getAnnotatedVersionedClusterState() {
        return this.currentClusterState;
    }

    public ClusterState getVersionedClusterState() {
        return this.currentClusterState.getClusterState();
    }

    public void updateLatestCandidateState(AnnotatedClusterState candidate) {
        assert (this.latestCandidateState.getClusterState().getVersion() == 0);
        this.latestCandidateState = candidate;
    }

    public AnnotatedClusterState getLatestCandidateState() {
        return this.latestCandidateState;
    }

    public List<ClusterStateHistoryEntry> getClusterStateHistory() {
        return Collections.unmodifiableList(this.clusterStateHistory);
    }

    boolean candidateChangedEnoughFromCurrentToWarrantPublish() {
        return !this.currentUnversionedState.similarToIgnoringInitProgress(this.latestCandidateState.getClusterState());
    }

    void promoteCandidateToVersionedState(long currentTimeMs) {
        int newVersion = this.currentVersion + 1;
        this.updateStatesForNewVersion(this.latestCandidateState, newVersion);
        this.currentVersion = newVersion;
        this.recordCurrentStateInHistoryAtTime(currentTimeMs);
    }

    private void updateStatesForNewVersion(AnnotatedClusterState newState, int newVersion) {
        this.currentClusterState = new AnnotatedClusterState(newState.getClusterState().clone(), newState.getClusterStateReason(), newState.getNodeStateReasons());
        this.currentClusterState.getClusterState().setVersion(newVersion);
        this.currentUnversionedState = newState.getClusterState().clone();
        this.lowestObservedDistributionBits = Math.min(this.lowestObservedDistributionBits, newState.getClusterState().getDistributionBitCount());
        this.clusterStateView = ClusterStateView.create(this.currentClusterState.getClusterState());
    }

    private void recordCurrentStateInHistoryAtTime(long currentTimeMs) {
        this.clusterStateHistory.addFirst(new ClusterStateHistoryEntry(this.currentClusterState.getClusterState(), currentTimeMs));
        while (this.clusterStateHistory.size() > this.maxHistoryEntryCount) {
            this.clusterStateHistory.removeLast();
        }
    }

    void handleUpdatedHostInfo(Map<Integer, String> hostnames, NodeInfo node, HostInfo hostInfo) {
        this.clusterStateView.handleUpdatedHostInfo(hostnames, node, hostInfo);
    }
}

