/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterEvent;
import com.yahoo.vespa.clustercontroller.core.ClusterStateReason;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.NodeEvent;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeStateReason;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class EventDiffCalculator {
    public static List<Event> computeEventDiff(Params params) {
        ArrayList<Event> events = new ArrayList<Event>();
        EventDiffCalculator.emitPerNodeDiffEvents(params, events);
        EventDiffCalculator.emitWholeClusterDiffEvent(params, events);
        return events;
    }

    private static ClusterEvent createClusterEvent(String description, Params params) {
        return new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, description, params.currentTime);
    }

    private static boolean clusterDownBecause(Params params, ClusterStateReason wantedReason) {
        Optional<ClusterStateReason> actualReason = params.toState.getClusterStateReason();
        return actualReason.isPresent() && actualReason.get().equals((Object)wantedReason);
    }

    private static void emitWholeClusterDiffEvent(Params params, List<Event> events) {
        ClusterState toState;
        ClusterState fromState = params.fromState.getClusterState();
        if (EventDiffCalculator.clusterHasTransitionedToUpState(fromState, toState = params.toState.getClusterState())) {
            events.add(EventDiffCalculator.createClusterEvent("Enough nodes available for system to become up", params));
        } else if (EventDiffCalculator.clusterHasTransitionedToDownState(fromState, toState)) {
            if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_FEW_STORAGE_NODES_AVAILABLE)) {
                events.add(EventDiffCalculator.createClusterEvent("Too few storage nodes available in cluster. Setting cluster state down", params));
            } else if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_FEW_DISTRIBUTOR_NODES_AVAILABLE)) {
                events.add(EventDiffCalculator.createClusterEvent("Too few distributor nodes available in cluster. Setting cluster state down", params));
            } else if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_LOW_AVAILABLE_STORAGE_NODE_RATIO)) {
                events.add(EventDiffCalculator.createClusterEvent("Too low ratio of available storage nodes. Setting cluster state down", params));
            } else if (EventDiffCalculator.clusterDownBecause(params, ClusterStateReason.TOO_LOW_AVAILABLE_DISTRIBUTOR_NODE_RATIO)) {
                events.add(EventDiffCalculator.createClusterEvent("Too low ratio of available distributor nodes. Setting cluster state down", params));
            } else {
                events.add(EventDiffCalculator.createClusterEvent("Cluster is down", params));
            }
        }
    }

    private static NodeEvent createNodeEvent(NodeInfo nodeInfo, String description, Params params) {
        return new NodeEvent(nodeInfo, description, NodeEvent.Type.CURRENT, params.currentTime);
    }

    private static void emitPerNodeDiffEvents(Params params, List<Event> events) {
        ContentCluster cluster = params.cluster;
        ClusterState fromState = params.fromState.getClusterState();
        ClusterState toState = params.toState.getClusterState();
        for (ConfiguredNode node : cluster.getConfiguredNodes().values()) {
            for (NodeType nodeType : NodeType.getTypes()) {
                Node n = new Node(nodeType, node.index());
                EventDiffCalculator.emitSingleNodeEvents(params, events, cluster, fromState, toState, n);
            }
        }
    }

    private static void emitSingleNodeEvents(Params params, List<Event> events, ContentCluster cluster, ClusterState fromState, ClusterState toState, Node n) {
        NodeState nodeFrom = fromState.getNodeState(n);
        NodeState nodeTo = toState.getNodeState(n);
        if (!nodeTo.equals((Object)nodeFrom)) {
            NodeInfo info = cluster.getNodeInfo(n);
            events.add(EventDiffCalculator.createNodeEvent(info, String.format("Altered node state in cluster state from '%s' to '%s'", nodeFrom.toString(true), nodeTo.toString(true)), params));
            NodeStateReason prevReason = params.fromState.getNodeStateReasons().get(n);
            NodeStateReason currReason = params.toState.getNodeStateReasons().get(n);
            if (EventDiffCalculator.isGroupDownEdge(prevReason, currReason)) {
                events.add(EventDiffCalculator.createNodeEvent(info, "Group node availability is below configured threshold", params));
            } else if (EventDiffCalculator.isGroupUpEdge(prevReason, currReason)) {
                events.add(EventDiffCalculator.createNodeEvent(info, "Group node availability has been restored", params));
            }
        }
    }

    private static boolean isGroupUpEdge(NodeStateReason prevReason, NodeStateReason currReason) {
        return prevReason == NodeStateReason.GROUP_IS_DOWN && currReason != NodeStateReason.GROUP_IS_DOWN;
    }

    private static boolean isGroupDownEdge(NodeStateReason prevReason, NodeStateReason currReason) {
        return prevReason != NodeStateReason.GROUP_IS_DOWN && currReason == NodeStateReason.GROUP_IS_DOWN;
    }

    private static boolean clusterHasTransitionedToUpState(ClusterState prevState, ClusterState currentState) {
        return prevState.getClusterState() != State.UP && currentState.getClusterState() == State.UP;
    }

    private static boolean clusterHasTransitionedToDownState(ClusterState prevState, ClusterState currentState) {
        return prevState.getClusterState() != State.DOWN && currentState.getClusterState() == State.DOWN;
    }

    public static Params params() {
        return new Params();
    }

    static class Params {
        ContentCluster cluster;
        AnnotatedClusterState fromState;
        AnnotatedClusterState toState;
        long currentTime;

        Params() {
        }

        public Params cluster(ContentCluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Params fromState(AnnotatedClusterState clusterState) {
            this.fromState = clusterState;
            return this;
        }

        public Params toState(AnnotatedClusterState clusterState) {
            this.toState = clusterState;
            return this;
        }

        public Params currentTimeMs(long time) {
            this.currentTime = time;
            return this;
        }
    }
}

