/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.google.common.base.Preconditions;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.GetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.SetClusterStateRequest;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCGetNodeStateRequest;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCGetNodeStateWaiter;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCSetClusterStateRequest;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCSetClusterStateWaiter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RPCCommunicator
implements Communicator {
    public static final Logger log = Logger.getLogger(RPCCommunicator.class.getName());
    private final Timer timer;
    private final Supervisor supervisor;
    private double nodeStateRequestTimeoutIntervalMaxSeconds;
    private int nodeStateRequestTimeoutIntervalStartPercentage;
    private int nodeStateRequestTimeoutIntervalStopPercentage;
    private int nodeStateRequestRoundTripTimeMaxSeconds;
    private final int fleetControllerIndex;

    public RPCCommunicator(Timer t, int index, int nodeStateRequestTimeoutIntervalMaxMs, int nodeStateRequestTimeoutIntervalStartPercentage, int nodeStateRequestTimeoutIntervalStopPercentage, int nodeStateRequestRoundTripTimeMaxSeconds) {
        this.timer = t;
        this.fleetControllerIndex = index;
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalMaxMs > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStartPercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStartPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStopPercentage >= nodeStateRequestTimeoutIntervalStartPercentage ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestTimeoutIntervalStartPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((nodeStateRequestRoundTripTimeMaxSeconds >= 0 ? 1 : 0) != 0);
        this.nodeStateRequestTimeoutIntervalMaxSeconds = (double)nodeStateRequestTimeoutIntervalMaxMs / 1000.0;
        this.nodeStateRequestTimeoutIntervalStartPercentage = nodeStateRequestTimeoutIntervalStartPercentage;
        this.nodeStateRequestTimeoutIntervalStopPercentage = nodeStateRequestTimeoutIntervalStopPercentage;
        this.nodeStateRequestRoundTripTimeMaxSeconds = nodeStateRequestRoundTripTimeMaxSeconds;
        this.supervisor = new Supervisor(new Transport());
    }

    @Override
    public void shutdown() {
        this.supervisor.transport().shutdown().join();
    }

    public Target getConnection(NodeInfo node) {
        Target t = node.getConnection();
        if (t == null || !t.isValid()) {
            t = node.setConnection(this.supervisor.connect(new Spec(node.getRpcAddress())));
        }
        return t;
    }

    public void doVersion0HandShake(Target connection, final NodeInfo node) {
        log.log((Level)LogLevel.DEBUG, "Sending version 0 handshake request as version has been set down to 0 for " + node);
        Request req = new Request("vespa.storage.connect");
        req.parameters().add((Value)new StringValue("storage/cluster." + node.getCluster().getName() + (node.isDistributor() ? "/distributor/" : "/storage/") + node.getNodeIndex()));
        connection.invokeAsync(req, 10.0, new RequestWaiter(){

            public void handleRequestDone(Request req) {
                if (req.isError()) {
                    log.log(LogLevel.WARNING, "Failed to do version 0 handshake towards " + node + ", " + req.errorCode() + ": " + req.errorMessage());
                } else if (!req.checkReturnTypes("i")) {
                    log.log(LogLevel.WARNING, "Wrong arguments returned from version 0 handshake attempt towards " + node);
                } else if (req.returnValues().get(0).asInt32() == 1) {
                    log.log((Level)LogLevel.DEBUG, "Session already opened when handshaking towards " + node + ".");
                } else if (req.returnValues().get(0).asInt32() > 1) {
                    log.log(LogLevel.WARNING, "Handshaking attempt towards " + node + " failed with code " + req.returnValues().get(0).asInt32());
                }
            }
        });
        node.setConnectionVersion(0);
    }

    public void clearOldStoredNodeState(Target connection, final NodeInfo node) {
        log.log((Level)LogLevel.DEBUG, "In case old node had stored a wanted state it is reporting, send a command to clear any unwanted stored state.");
        Request req = new Request("setnodestate");
        req.parameters().add((Value)new StringValue(""));
        connection.invokeAsync(req, 10.0, new RequestWaiter(){

            public void handleRequestDone(Request req) {
                if (req.isError()) {
                    if (node.getReportedState().getState() != State.DOWN) {
                        log.log(LogLevel.WARNING, "Failed to clear nodestate on old node " + node + ", " + req.errorCode() + ": " + req.errorMessage());
                    }
                } else if (!req.checkReturnTypes("is")) {
                    log.log(LogLevel.WARNING, "Wrong arguments returned from version 0 setnodestate attempt to clear any unwanted state on " + node);
                }
            }
        });
    }

    @Override
    public void propagateOptions(FleetControllerOptions options) {
        Preconditions.checkArgument((options.nodeStateRequestTimeoutMS > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutEarliestPercentage >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutEarliestPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutLatestPercentage >= options.nodeStateRequestTimeoutEarliestPercentage ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestTimeoutLatestPercentage <= 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((options.nodeStateRequestRoundTripTimeMaxSeconds >= 0 ? 1 : 0) != 0);
        this.nodeStateRequestTimeoutIntervalMaxSeconds = (double)options.nodeStateRequestTimeoutMS / 1000.0;
        this.nodeStateRequestTimeoutIntervalStartPercentage = options.nodeStateRequestTimeoutEarliestPercentage;
        this.nodeStateRequestTimeoutIntervalStopPercentage = options.nodeStateRequestTimeoutLatestPercentage;
        this.nodeStateRequestRoundTripTimeMaxSeconds = options.nodeStateRequestRoundTripTimeMaxSeconds;
    }

    @Override
    public void getNodeState(NodeInfo node, Communicator.Waiter<GetNodeStateRequest> externalWaiter) {
        Request req;
        Target connection = this.getConnection(node);
        if (!connection.isValid()) {
            log.log((Level)LogLevel.DEBUG, "Connection to " + node.getRpcAddress() + " could not be created.");
        }
        if (node.getVersion() == 0 && node.getConnectionVersion() > 0) {
            this.doVersion0HandShake(connection, node);
            this.clearOldStoredNodeState(connection, node);
        }
        NodeState currentState = node.getReportedState();
        if (node.getVersion() == 0) {
            req = new Request("getnodestate");
        } else {
            req = new Request(node.getVersion() == 1 ? "getnodestate2" : "getnodestate3");
            req.parameters().add((Value)new StringValue(currentState.getState().equals((Object)State.DOWN) || node.getConnectionAttemptCount() > 0 ? "unknown" : currentState.serialize()));
            req.parameters().add((Value)new Int32Value(this.generateNodeStateRequestTimeoutMs()));
            if (node.getVersion() > 1) {
                req.parameters().add((Value)new Int32Value(this.fleetControllerIndex));
            }
        }
        RPCGetNodeStateRequest stateRequest = new RPCGetNodeStateRequest(node, req);
        RPCGetNodeStateWaiter waiter = new RPCGetNodeStateWaiter(stateRequest, externalWaiter, this.timer);
        double requestTimeoutSeconds = this.nodeStateRequestTimeoutIntervalMaxSeconds + (double)this.nodeStateRequestRoundTripTimeMaxSeconds;
        connection.invokeAsync(req, requestTimeoutSeconds, (RequestWaiter)waiter);
        node.setCurrentNodeStateRequest(stateRequest, this.timer.getCurrentTimeInMillis());
        node.lastRequestInfoConnection = connection;
    }

    @Override
    public void setSystemState(ClusterState state, NodeInfo node, Communicator.Waiter<SetClusterStateRequest> externalWaiter) {
        Request req;
        RPCSetClusterStateWaiter waiter = new RPCSetClusterStateWaiter(externalWaiter, this.timer);
        Target connection = this.getConnection(node);
        if (!connection.isValid()) {
            log.log((Level)LogLevel.DEBUG, "Connection to " + node.getRpcAddress() + " could not be created.");
            return;
        }
        if (node.getVersion() == 0 && node.getConnectionVersion() > 0) {
            this.doVersion0HandShake(connection, node);
            this.clearOldStoredNodeState(connection, node);
        }
        if (node.getVersion() == 0) {
            req = new Request("setsystemstate");
            req.parameters().add((Value)new StringValue(state.toString(true)));
        } else {
            req = new Request("setsystemstate2");
            req.parameters().add((Value)new StringValue(state.toString(false)));
        }
        RPCSetClusterStateRequest stateRequest = new RPCSetClusterStateRequest(node, req, state.getVersion());
        waiter.setRequest(stateRequest);
        connection.invokeAsync(req, 60.0, (RequestWaiter)waiter);
        node.setSystemStateVersionSent(state);
    }

    protected int generateNodeStateRequestTimeoutMs() {
        double intervalFraction = Math.random();
        double earliestTimeoutSeconds = this.nodeStateRequestTimeoutIntervalMaxSeconds * (double)this.nodeStateRequestTimeoutIntervalStartPercentage / 100.0;
        double latestTimeoutSeconds = this.nodeStateRequestTimeoutIntervalMaxSeconds * (double)this.nodeStateRequestTimeoutIntervalStopPercentage / 100.0;
        double interval = latestTimeoutSeconds - earliestTimeoutSeconds;
        double timeoutSeconds = earliestTimeoutSeconds + intervalFraction * interval;
        return (int)(timeoutSeconds * 1000.0);
    }
}

