/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.NodeMergeStats;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StorageMergeStats
implements Iterable<NodeMergeStats> {
    private final Map<Integer, NodeMergeStats> mapToNodeStats;

    public StorageMergeStats(Set<Integer> storageNodes) {
        this.mapToNodeStats = new HashMap<Integer, NodeMergeStats>(storageNodes.size());
        for (Integer index : storageNodes) {
            this.mapToNodeStats.put(index, new NodeMergeStats(index));
        }
    }

    public StorageMergeStats(Map<Integer, NodeMergeStats> mapToNodeStats) {
        this.mapToNodeStats = mapToNodeStats;
    }

    @Override
    public Iterator<NodeMergeStats> iterator() {
        return this.mapToNodeStats.values().iterator();
    }

    NodeMergeStats getStorageNode(Integer index) {
        return this.mapToNodeStats.get(index);
    }

    int size() {
        return this.mapToNodeStats.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageMergeStats)) {
            return false;
        }
        StorageMergeStats that = (StorageMergeStats)o;
        return !(this.mapToNodeStats != null ? !this.mapToNodeStats.equals(that.mapToNodeStats) : that.mapToNodeStats != null);
    }

    public int hashCode() {
        return this.mapToNodeStats != null ? this.mapToNodeStats.hashCode() : 0;
    }
}

