/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.clustercontroller.core.MetricUpdater;
import com.yahoo.vespa.clustercontroller.core.NodeMergeStats;
import com.yahoo.vespa.clustercontroller.core.StorageMergeStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterStatsAggregator {
    private static Logger log = Logger.getLogger(ClusterStatsAggregator.class.getName());
    private final Set<Integer> distributors;
    private final MetricUpdater updater;
    private final Map<Integer, StorageMergeStats> distributorToStats = new HashMap<Integer, StorageMergeStats>();
    private final StorageMergeStats aggregatedStats;
    private int hostToStatsMapHashCode = 0;

    ClusterStatsAggregator(Set<Integer> distributors, Set<Integer> storageNodes, MetricUpdater updater) {
        this.distributors = distributors;
        this.aggregatedStats = new StorageMergeStats(storageNodes);
        this.updater = updater;
    }

    void updateForDistributor(Map<Integer, String> hostnames, int distributorIndex, StorageMergeStats storageStats) {
        if (!this.distributors.contains(distributorIndex)) {
            return;
        }
        this.addStatsFromDistributor(distributorIndex, storageStats);
        if (this.distributorToStats.size() < this.distributors.size()) {
            return;
        }
        Map<String, NodeMergeStats> hostToStatsMap = this.getHostToStatsMap(hostnames);
        if (hostToStatsMap == null) {
            return;
        }
        if (this.hostToStatsMapHashCode == 0 || this.hostToStatsMapHashCode != hostToStatsMap.hashCode()) {
            this.updater.updateMergeOpMetrics(hostToStatsMap);
            this.hostToStatsMapHashCode = hostToStatsMap.hashCode();
        }
    }

    private Map<String, NodeMergeStats> getHostToStatsMap(Map<Integer, String> hostnames) {
        HashMap<String, NodeMergeStats> hostToStatsMap = new HashMap<String, NodeMergeStats>(this.aggregatedStats.size());
        for (NodeMergeStats nodeStats : this.aggregatedStats) {
            String host = hostnames.get(nodeStats.getNodeIndex());
            if (host == null) {
                log.log((Level)LogLevel.DEBUG, "Failed to find the host name of storage node " + nodeStats.getNodeIndex() + ". Skipping the report from " + ClusterStatsAggregator.class.getName());
                return null;
            }
            hostToStatsMap.put(host, nodeStats);
        }
        return hostToStatsMap;
    }

    private void addStatsFromDistributor(int distributorIndex, StorageMergeStats storageStatsFromDistributor) {
        StorageMergeStats previousStorageStats = this.distributorToStats.put(distributorIndex, storageStatsFromDistributor);
        for (NodeMergeStats storageNode : this.aggregatedStats) {
            NodeMergeStats statsToSubtract;
            Integer storageNodeIndex = storageNode.getNodeIndex();
            NodeMergeStats statsToAdd = storageStatsFromDistributor.getStorageNode(storageNodeIndex);
            if (statsToAdd != null) {
                storageNode.add(statsToAdd);
            }
            if (previousStorageStats == null || (statsToSubtract = storageStatsFromDistributor.getStorageNode(storageNodeIndex)) == null) continue;
            storageNode.subtract(statsToSubtract);
        }
    }
}

