/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.restapiv2.requests;

import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Id;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Request;
import com.yahoo.vespa.clustercontroller.core.restapiv2.Response;
import com.yahoo.vespa.clustercontroller.core.restapiv2.requests.ServiceStateRequest;
import com.yahoo.vespa.clustercontroller.utils.staterestapi.errors.StateRestApiException;

public class ClusterStateRequest
extends Request<Response.ClusterResponse> {
    private final Id.Cluster id;
    private final int recursive;

    public ClusterStateRequest(Id.Cluster id, int recursive) {
        super(Request.MasterState.MUST_BE_MASTER);
        this.id = id;
        this.recursive = recursive;
    }

    @Override
    public Response.ClusterResponse calculateResult(RemoteClusterControllerTask.Context context) throws StateRestApiException {
        Response.ClusterResponse result = new Response.ClusterResponse();
        result.addState("generated", new Response.UnitStateImpl(context.currentState.getClusterState()));
        for (NodeType type : NodeType.getTypes()) {
            Id.Service serviceId = new Id.Service(this.id, type);
            if (this.recursive > 0) {
                ServiceStateRequest ssr = new ServiceStateRequest(serviceId, this.recursive - 1);
                result.addEntry("service", type.toString(), ssr.calculateResult(context));
                continue;
            }
            result.addLink("service", type.toString(), serviceId.toString());
        }
        return result;
    }
}

