/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.hostinfo.StorageNode;

public class NodeMergeStats {
    private final Amount syncing;
    private final Amount copyingIn;
    private final Amount movingOut;
    private final Amount copyingOut;
    private int nodeIndex;

    public NodeMergeStats(StorageNode storageNodePojo) {
        this.nodeIndex = storageNodePojo.getIndex();
        StorageNode.OutstandingMergeOps mergeOps = storageNodePojo.getOutstandingMergeOpsOrNull();
        if (mergeOps == null) {
            mergeOps = new StorageNode.OutstandingMergeOps();
        }
        this.syncing = NodeMergeStats.createAmount(mergeOps.getSyncingOrNull());
        this.copyingIn = NodeMergeStats.createAmount(mergeOps.getCopyingInOrNull());
        this.movingOut = NodeMergeStats.createAmount(mergeOps.getMovingOutOrNull());
        this.copyingOut = NodeMergeStats.createAmount(mergeOps.getCopyingOutOrNull());
    }

    private static Amount createAmount(StorageNode.Buckets bucketOrNull) {
        if (bucketOrNull == null) {
            return new Amount();
        }
        return new Amount(bucketOrNull.getBuckets());
    }

    public NodeMergeStats(int index) {
        this(index, new Amount(), new Amount(), new Amount(), new Amount());
    }

    NodeMergeStats(int index, Amount syncing, Amount copyingIn, Amount movingOut, Amount copyingOut) {
        this.nodeIndex = index;
        this.syncing = syncing;
        this.copyingIn = copyingIn;
        this.movingOut = movingOut;
        this.copyingOut = copyingOut;
    }

    public void set(NodeMergeStats stats) {
        this.nodeIndex = stats.nodeIndex;
        this.syncing.set(stats.syncing);
        this.copyingIn.set(stats.copyingIn);
        this.movingOut.set(stats.movingOut);
        this.copyingOut.set(stats.copyingOut);
    }

    int getNodeIndex() {
        return this.nodeIndex;
    }

    public Amount getSyncing() {
        return this.syncing;
    }

    public Amount getCopyingIn() {
        return this.copyingIn;
    }

    public Amount getMovingOut() {
        return this.movingOut;
    }

    public Amount getCopyingOut() {
        return this.copyingOut;
    }

    void add(NodeMergeStats stats) {
        this.scaledAdd(1, stats);
    }

    void subtract(NodeMergeStats stats) {
        this.scaledAdd(-1, stats);
    }

    private void scaledAdd(int factor, NodeMergeStats stats) {
        this.syncing.scaledAdd(factor, stats.syncing);
        this.copyingIn.scaledAdd(factor, stats.copyingIn);
        this.movingOut.scaledAdd(factor, stats.movingOut);
        this.copyingOut.scaledAdd(factor, stats.copyingOut);
    }

    public int hashCode() {
        return (int)(this.syncing.buckets + this.copyingIn.buckets * 31L + this.movingOut.buckets * 17L + this.copyingOut.buckets * 7L);
    }

    public boolean equals(Object other) {
        if (!(other instanceof NodeMergeStats)) {
            return false;
        }
        NodeMergeStats otherStats = (NodeMergeStats)other;
        return this.nodeIndex == otherStats.nodeIndex && this.syncing.equals(otherStats.syncing) && this.copyingIn.equals(otherStats.copyingIn) && this.movingOut.equals(otherStats.movingOut) && this.copyingOut.equals(otherStats.copyingOut);
    }

    public String toString() {
        return String.format("{index = %d, syncing = %s, copyingIn = %s, movingOut = %s, copyingOut = %s}", this.nodeIndex, this.syncing, this.copyingIn, this.movingOut, this.copyingOut);
    }

    public static class Amount {
        private long buckets;

        Amount() {
            this(0L);
        }

        Amount(long buckets) {
            this.buckets = buckets;
        }

        public void set(Amount other) {
            this.buckets = other.buckets;
        }

        public long getBuckets() {
            return this.buckets;
        }

        void scaledAdd(int factor, Amount amount) {
            this.buckets += (long)factor * amount.buckets;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Amount)) {
                return false;
            }
            Amount otherAmount = (Amount)other;
            return this.buckets == otherAmount.buckets;
        }

        public int hashCode() {
            return (int)this.buckets;
        }

        public String toString() {
            return String.format("{buckets = %d}", this.buckets);
        }
    }
}

