/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.apputil.communication.http;

import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequestHandler;
import com.yahoo.vespa.clustercontroller.utils.communication.http.HttpResult;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.logging.Logger;

public class JDiscHttpRequestHandler
extends ThreadedHttpRequestHandler {
    private static final Logger log = Logger.getLogger(JDiscHttpRequestHandler.class.getName());
    private final HttpRequestHandler requestHandler;

    public JDiscHttpRequestHandler(HttpRequestHandler handler, ThreadedHttpRequestHandler.Context parentCtx) {
        super(parentCtx);
        this.requestHandler = handler;
    }

    public HttpResponse handle(com.yahoo.container.jdisc.HttpRequest request) {
        com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest legacyRequest = new com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest();
        HttpRequest jDiscRequest = request.getJDiscRequest();
        legacyRequest.setScheme(request.getUri().getScheme());
        legacyRequest.setHost(request.getUri().getHost());
        JDiscHttpRequestHandler.setOperation(legacyRequest, request.getMethod());
        legacyRequest.setPort(request.getUri().getPort());
        legacyRequest.setPath(request.getUri().getPath());
        this.copyPostData(request, legacyRequest);
        JDiscHttpRequestHandler.copyRequestHeaders(legacyRequest, jDiscRequest);
        JDiscHttpRequestHandler.copyParameters(legacyRequest, jDiscRequest);
        legacyRequest.setTimeout(Duration.ofMinutes(60L).toMillis());
        try {
            HttpResult result = this.requestHandler.handleRequest(legacyRequest);
            log.fine("Got result " + result.toString(true));
            return this.copyResponse(result);
        }
        catch (Exception e) {
            log.warning("Caught exception while handling request: " + e.getMessage());
            return new HttpResponse(500){

                public void render(OutputStream outputStream) throws IOException {
                    outputStream.write(Utf8.toBytes((String)e.getMessage()));
                }
            };
        }
    }

    static com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest setOperation(com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest request, HttpRequest.Method method) {
        return switch (method) {
            case HttpRequest.Method.GET -> request.setHttpOperation(HttpRequest.HttpOp.GET);
            case HttpRequest.Method.POST -> request.setHttpOperation(HttpRequest.HttpOp.POST);
            case HttpRequest.Method.PUT -> request.setHttpOperation(HttpRequest.HttpOp.PUT);
            case HttpRequest.Method.DELETE -> request.setHttpOperation(HttpRequest.HttpOp.DELETE);
            default -> throw new IllegalStateException("Unhandled method " + String.valueOf(method));
        };
    }

    private HttpResponse copyResponse(final HttpResult result) {
        return new HttpResponse(result.getHttpReturnCode()){

            public void render(OutputStream outputStream) throws IOException {
                outputStream.write(Utf8.toBytes((String)result.getContent().toString()));
            }

            public void complete() {
                JDiscHttpRequestHandler.copyResponseHeaders(result, this.getJdiscResponse());
            }
        };
    }

    private void copyPostData(com.yahoo.container.jdisc.HttpRequest request, com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest legacyRequest) {
        try {
            legacyRequest.setPostContent((Object)new String(request.getData().readAllBytes(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyParameters(com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest legacyRequest, HttpRequest jDiscRequest) {
        for (String key : jDiscRequest.parameters().keySet()) {
            for (String value : (List)jDiscRequest.parameters().get(key)) {
                legacyRequest.addUrlOption(key, value);
            }
        }
    }

    private static void copyRequestHeaders(com.yahoo.vespa.clustercontroller.utils.communication.http.HttpRequest legacyRequest, HttpRequest jDiscRequest) {
        for (String key : jDiscRequest.headers().keySet()) {
            for (String value : jDiscRequest.headers().get((Object)key)) {
                legacyRequest.addHttpHeader(key, value);
            }
        }
    }

    private static HeaderFields copyResponseHeaders(HttpResult result, Response response) {
        HeaderFields headers = new HeaderFields();
        for (HttpRequest.KeyValuePair keyValuePair : result.getHeaders()) {
            response.headers().put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return headers;
    }

    static class EmptyCompletionHandler
    implements CompletionHandler {
        EmptyCompletionHandler() {
        }

        public void completed() {
        }

        public void failed(Throwable throwable) {
        }
    }
}

