/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.apps.clustercontroller;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.Metric;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.apps.clustercontroller.ClusterController;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.zookeeper.server.VespaZooKeeperServer;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;

public class ClusterControllerClusterConfigurer
extends AbstractComponent {
    private final FleetControllerOptions options;
    private final ClusterController controller;

    @Inject
    public ClusterControllerClusterConfigurer(ClusterController controller, StorDistributionConfig distributionConfig, FleetcontrollerConfig fleetcontrollerConfig, SlobroksConfig slobroksConfig, ZookeepersConfig zookeepersConfig, Metric metricImpl, VespaZooKeeperServer started) throws Exception {
        this.options = ClusterControllerClusterConfigurer.configure(distributionConfig, fleetcontrollerConfig, slobroksConfig, zookeepersConfig);
        this.controller = controller;
        if (controller != null) {
            controller.setOptions(this.options, metricImpl);
        }
    }

    public void deconstruct() {
        if (this.controller != null) {
            this.controller.countdown(this.options.clusterName());
        }
    }

    FleetControllerOptions getOptions() {
        return this.options;
    }

    private static FleetControllerOptions configure(StorDistributionConfig distributionConfig, FleetcontrollerConfig fleetcontrollerConfig, SlobroksConfig slobroksConfig, ZookeepersConfig zookeepersConfig) {
        Distribution distribution = new Distribution(distributionConfig);
        FleetControllerOptions.Builder builder = new FleetControllerOptions.Builder(fleetcontrollerConfig.cluster_name(), (Collection)distribution.getNodes());
        builder.setStorageDistribution(distribution);
        ClusterControllerClusterConfigurer.configure(builder, fleetcontrollerConfig);
        ClusterControllerClusterConfigurer.configure(builder, slobroksConfig);
        ClusterControllerClusterConfigurer.configure(builder, zookeepersConfig);
        return builder.build();
    }

    private static void configure(FleetControllerOptions.Builder builder, FleetcontrollerConfig config) {
        builder.setClusterName(config.cluster_name());
        builder.setIndex(config.index());
        builder.setCount(config.fleet_controller_count());
        builder.setZooKeeperSessionTimeout((int)(config.zookeeper_session_timeout() * 1000.0));
        builder.setMasterZooKeeperCooldownPeriod((int)(config.master_zookeeper_cooldown_period() * 1000.0));
        builder.setRpcPort(config.rpc_port());
        builder.setHttpPort(config.http_port());
        builder.setMaxTransitionTime(NodeType.STORAGE, Integer.valueOf(config.storage_transition_time()));
        builder.setMaxTransitionTime(NodeType.DISTRIBUTOR, Integer.valueOf(config.distributor_transition_time()));
        builder.setMaxInitProgressTime(config.init_progress_time());
        builder.setMaxPrematureCrashes(config.max_premature_crashes());
        builder.setStableStateTimePeriod((long)config.stable_state_time_period());
        builder.setEventLogMaxSize(config.event_log_max_size());
        builder.setEventNodeLogMaxSize(config.event_node_log_max_size());
        builder.setMinDistributorNodesUp(config.min_distributors_up_count());
        builder.setMinStorageNodesUp(config.min_storage_up_count());
        builder.setMinRatioOfDistributorNodesUp(config.min_distributor_up_ratio());
        builder.setMinRatioOfStorageNodesUp(config.min_storage_up_ratio());
        builder.setCycleWaitTime((int)(config.cycle_wait_time() * 1000.0));
        builder.setMinTimeBeforeFirstSystemStateBroadcast((long)((int)(config.min_time_before_first_system_state_broadcast() * 1000.0)));
        builder.setNodeStateRequestTimeoutMS((int)(config.get_node_state_request_timeout() * 1000.0));
        builder.setShowLocalSystemStatesInEventLog(config.show_local_systemstates_in_event_log());
        builder.setMinTimeBetweenNewSystemStates(config.min_time_between_new_systemstates());
        builder.setMaxSlobrokDisconnectGracePeriod((int)(config.max_slobrok_disconnect_grace_period() * 1000.0));
        builder.setDistributionBits(config.ideal_distribution_bits());
        builder.setMinNodeRatioPerGroup(config.min_node_ratio_per_group());
        builder.setMaxDeferredTaskVersionWaitTime(Duration.ofMillis((int)(config.max_deferred_task_version_wait_time_sec() * 1000.0)));
        builder.setClusterHasGlobalDocumentTypes(config.cluster_has_global_document_types());
        builder.setMinMergeCompletionRatio(config.min_merge_completion_ratio());
        builder.enableTwoPhaseClusterStateActivation(config.enable_two_phase_cluster_state_transitions());
        builder.setClusterFeedBlockEnabled(config.enable_cluster_feed_block());
        builder.setClusterFeedBlockLimit(Map.copyOf(config.cluster_feed_block_limit()));
        builder.setClusterFeedBlockNoiseLevel(config.cluster_feed_block_noise_level());
        builder.setMaxNumberOfGroupsAllowedToBeDown(config.max_number_of_groups_allowed_to_be_down());
    }

    private static void configure(FleetControllerOptions.Builder builder, SlobroksConfig config) {
        String[] specs = new String[config.slobrok().size()];
        for (int i = 0; i < config.slobrok().size(); ++i) {
            specs[i] = ((SlobroksConfig.Slobrok)config.slobrok().get(i)).connectionspec();
        }
        builder.setSlobrokConnectionSpecs(specs);
    }

    private static void configure(FleetControllerOptions.Builder builder, ZookeepersConfig config) {
        builder.setZooKeeperServerAddress(config.zookeeperserverlist());
    }
}

