/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.apps.clustercontroller;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.cloud.config.ZookeepersConfig;
import com.yahoo.jdisc.Metric;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.apps.clustercontroller.ClusterController;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import java.time.Duration;

public class ClusterControllerClusterConfigurer {
    private final FleetControllerOptions options = new FleetControllerOptions(null);

    public ClusterControllerClusterConfigurer(ClusterController controller, StorDistributionConfig distributionConfig, FleetcontrollerConfig fleetcontrollerConfig, SlobroksConfig slobroksConfig, ZookeepersConfig zookeepersConfig, Metric metricImpl) throws Exception {
        this.configure(distributionConfig);
        this.configure(fleetcontrollerConfig);
        this.configure(slobroksConfig);
        this.configure(zookeepersConfig);
        this.checkIfZooKeeperNeeded();
        if (controller != null) {
            controller.setOptions(this.options.clusterName, this.options, metricImpl);
        }
    }

    public FleetControllerOptions getOptions() {
        return this.options;
    }

    private void configure(StorDistributionConfig config) {
        this.options.setStorageDistribution(new Distribution(config));
    }

    private void configure(FleetcontrollerConfig config) {
        this.options.clusterName = config.cluster_name();
        this.options.fleetControllerIndex = config.index();
        this.options.fleetControllerCount = config.fleet_controller_count();
        this.options.zooKeeperSessionTimeout = (int)(config.zookeeper_session_timeout() * 1000.0);
        this.options.masterZooKeeperCooldownPeriod = (int)(config.master_zookeeper_cooldown_period() * 1000.0);
        this.options.stateGatherCount = config.state_gather_count();
        this.options.rpcPort = config.rpc_port();
        this.options.httpPort = config.http_port();
        this.options.maxTransitionTime.put(NodeType.STORAGE, config.storage_transition_time());
        this.options.maxTransitionTime.put(NodeType.DISTRIBUTOR, config.distributor_transition_time());
        this.options.maxInitProgressTime = config.init_progress_time();
        this.options.statePollingFrequency = config.state_polling_frequency();
        this.options.maxPrematureCrashes = config.max_premature_crashes();
        this.options.stableStateTimePeriod = config.stable_state_time_period();
        this.options.eventLogMaxSize = config.event_log_max_size();
        this.options.eventNodeLogMaxSize = config.event_node_log_max_size();
        this.options.minDistributorNodesUp = config.min_distributors_up_count();
        this.options.minStorageNodesUp = config.min_storage_up_count();
        this.options.minRatioOfDistributorNodesUp = config.min_distributor_up_ratio();
        this.options.minRatioOfStorageNodesUp = config.min_storage_up_ratio();
        this.options.cycleWaitTime = (int)(config.cycle_wait_time() * 1000.0);
        this.options.minTimeBeforeFirstSystemStateBroadcast = (int)(config.min_time_before_first_system_state_broadcast() * 1000.0);
        this.options.nodeStateRequestTimeoutMS = (int)(config.get_node_state_request_timeout() * 1000.0);
        this.options.showLocalSystemStatesInEventLog = config.show_local_systemstates_in_event_log();
        this.options.minTimeBetweenNewSystemStates = config.min_time_between_new_systemstates();
        this.options.maxSlobrokDisconnectGracePeriod = (int)(config.max_slobrok_disconnect_grace_period() * 1000.0);
        this.options.distributionBits = config.ideal_distribution_bits();
        this.options.minNodeRatioPerGroup = config.min_node_ratio_per_group();
        this.options.setMaxDeferredTaskVersionWaitTime(Duration.ofMillis((int)(config.max_deferred_task_version_wait_time_sec() * 1000.0)));
        this.options.enableMultipleBucketSpaces = config.enable_multiple_bucket_spaces();
    }

    private void configure(SlobroksConfig config) {
        String[] specs = new String[config.slobrok().size()];
        for (int i = 0; i < config.slobrok().size(); ++i) {
            specs[i] = ((SlobroksConfig.Slobrok)config.slobrok().get(i)).connectionspec();
        }
        this.options.slobrokConnectionSpecs = specs;
    }

    private void configure(ZookeepersConfig config) {
        this.options.zooKeeperServerAddress = config.zookeeperserverlist();
    }

    private void checkIfZooKeeperNeeded() {
        if (this.options.zooKeeperServerAddress == null || "".equals(this.options.zooKeeperServerAddress)) {
            if (this.options.fleetControllerCount > 1) {
                throw new IllegalArgumentException("Must set zookeeper server with multiple fleetcontrollers");
            }
            this.options.zooKeeperServerAddress = null;
        }
    }
}

