/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.Q;
import ai.vespa.client.dsl.Query;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Sources;
import ai.vespa.client.dsl.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Field
extends QueryChain {
    private final String fieldName;
    private List<Object> values = new ArrayList<Object>();
    private Annotation annotation = A.empty();
    private String relation;

    Field(Sources sources, String fieldName) {
        this.sources = sources;
        this.fieldName = fieldName;
    }

    Field(Query query, String fieldName) {
        this.query = query;
        this.fieldName = fieldName;
    }

    public Query contains(String value) {
        return this.contains(A.empty(), value);
    }

    public Query contains(Annotation annotation, String value) {
        return this.common("contains", annotation, value);
    }

    public Query containsPhrase(String value, String ... others) {
        return this.common("phrase", this.annotation, value, others);
    }

    public Query containsPhrase(List<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value of \"contains phrase\" should not be empty");
        }
        return this.common("phrase", this.annotation, values);
    }

    public Query containsNear(String value, String ... others) {
        return this.common("near", this.annotation, value, others);
    }

    public Query containsNear(List<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value of \"contains near\" should not be empty");
        }
        return this.common("near", this.annotation, values);
    }

    public Query containsNear(Annotation annotation, String value, String ... others) {
        return this.common("near", annotation, value, others);
    }

    public Query containsNear(Annotation annotation, List<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value of \"contains near\" should not be empty");
        }
        return this.common("near", annotation, values);
    }

    public Query containsOnear(String value, String ... others) {
        return this.common("onear", this.annotation, value, others);
    }

    public Query containsOnear(List<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value of \"contains onear\" should not be empty");
        }
        return this.common("onear", this.annotation, values);
    }

    public Query containsOnear(Annotation annotation, String value, String ... others) {
        return this.common("onear", annotation, value, others);
    }

    public Query containsOnear(Annotation annotation, List<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value of \"contains onear\" should not be empty");
        }
        return this.common("onear", annotation, values);
    }

    public Query containsSameElement(Query andQuery) {
        return this.common("sameElement", this.annotation, andQuery);
    }

    public Query containsEquiv(String value, String ... others) {
        return this.containsEquiv(Stream.concat(Stream.of(value), Stream.of(others)).collect(Collectors.toList()));
    }

    public Query containsEquiv(List<String> values) {
        if (values.isEmpty()) {
            throw new IllegalArgumentException("value of \"contains equiv\" should not be empty");
        }
        if (values.size() == 1) {
            return this.contains(values.get(0));
        }
        return this.common("equiv", this.annotation, values);
    }

    public Query containsUri(String value) {
        return this.common("uri", this.annotation, value);
    }

    public Query containsUri(Annotation annotation, String value) {
        return this.common("uri", annotation, value);
    }

    public Query matches(String str) {
        return this.common("matches", this.annotation, str);
    }

    public Query eq(int t) {
        return this.common("=", this.annotation, t);
    }

    public Query ge(int t) {
        return this.common(">=", this.annotation, t);
    }

    public Query gt(int t) {
        return this.common(">", this.annotation, t);
    }

    public Query le(int t) {
        return this.common("<=", this.annotation, t);
    }

    public Query lt(int t) {
        return this.common("<", this.annotation, t);
    }

    public Query inRange(int l, int m) {
        return this.common("range", this.annotation, l, new Integer[]{m});
    }

    public Query eq(long t) {
        return this.common("=", this.annotation, t);
    }

    public Query ge(long t) {
        return this.common(">=", this.annotation, t);
    }

    public Query gt(long t) {
        return this.common(">", this.annotation, t);
    }

    public Query le(long t) {
        return this.common("<=", this.annotation, t);
    }

    public Query lt(long t) {
        return this.common("<", this.annotation, t);
    }

    public Query inRange(long l, long m) {
        return this.common("range", this.annotation, l, new Long[]{m});
    }

    public Query eq(double t) {
        return this.common("=", this.annotation, t);
    }

    public Query ge(double t) {
        return this.common(">=", this.annotation, t);
    }

    public Query gt(double t) {
        return this.common(">", this.annotation, t);
    }

    public Query le(double t) {
        return this.common("<=", this.annotation, t);
    }

    public Query lt(double t) {
        return this.common("<", this.annotation, t);
    }

    public Query inRange(double l, double m) {
        return this.common("range", this.annotation, l, new Double[]{m});
    }

    public Query eq(float t) {
        return this.common("=", this.annotation, Float.valueOf(t));
    }

    public Query ge(float t) {
        return this.common(">=", this.annotation, Float.valueOf(t));
    }

    public Query gt(float t) {
        return this.common(">", this.annotation, Float.valueOf(t));
    }

    public Query le(float t) {
        return this.common("<=", this.annotation, Float.valueOf(t));
    }

    public Query lt(float t) {
        return this.common("<", this.annotation, Float.valueOf(t));
    }

    public Query inRange(float l, float m) {
        return this.common("range", this.annotation, Float.valueOf(l), new Float[]{Float.valueOf(m)});
    }

    public Query isTrue() {
        return this.common("=", this.annotation, true);
    }

    public Query isFalse() {
        return this.common("=", this.annotation, false);
    }

    public Query nearestNeighbor(String rankFeature) {
        return this.common("nearestNeighbor", this.annotation, (Object)rankFeature);
    }

    public Query nearestNeighbor(Annotation annotation, String rankFeature) {
        return this.common("nearestNeighbor", annotation, (Object)rankFeature);
    }

    public Query fuzzy(String text) {
        return this.common("fuzzy", this.annotation, text);
    }

    public Query fuzzy(Annotation annotation, String text) {
        return this.common("fuzzy", annotation, text);
    }

    private Query common(String relation, Annotation annotation, Object value) {
        return this.common(relation, annotation, value, this.values.toArray());
    }

    private Query common(String relation, Annotation annotation, String value) {
        String v = Q.toJson(value);
        return this.common(relation, annotation, (Object)v, this.values.toArray());
    }

    private Query common(String relation, Annotation annotation, List<String> values) {
        return this.common(relation, annotation, values.get(0), values.subList(1, values.size()).toArray(new String[0]));
    }

    private Query common(String relation, Annotation annotation, String value, String[] others) {
        String v = Q.toJson(value);
        Object[] o = Stream.of(others).map(Q::toJson).toArray();
        return this.common(relation, annotation, (Object)v, o);
    }

    private Query common(String relation, Annotation annotation, Object value, Object[] others) {
        this.annotation = annotation;
        this.relation = relation;
        this.values = Stream.concat(Stream.of(value), Stream.of(others)).collect(Collectors.toList());
        this.nonEmpty = true;
        return this.query != null ? this.query : new Query(this.sources, this);
    }

    public String toString() {
        boolean hasAnnotation = !A.empty().equals(this.annotation);
        switch (this.relation) {
            case "range": {
                String valuesStr = this.values.stream().map(i -> i instanceof Long ? String.valueOf(i) + "L" : i.toString()).collect(Collectors.joining(", "));
                return hasAnnotation ? Text.format("([%s]range(%s, %s))", this.annotation, this.fieldName, valuesStr) : Text.format("range(%s, %s)", this.fieldName, valuesStr);
            }
            case "near": 
            case "onear": 
            case "phrase": 
            case "equiv": 
            case "uri": {
                String valuesStr = this.values.stream().map(Object::toString).collect(Collectors.joining(", "));
                return hasAnnotation ? Text.format("%s contains ([%s]%s(%s))", this.fieldName, this.annotation, this.relation, valuesStr) : Text.format("%s contains %s(%s)", this.fieldName, this.relation, valuesStr);
            }
            case "sameElement": {
                return Text.format("%s contains %s(%s)", this.fieldName, this.relation, ((Query)this.values.get(0)).toCommaSeparatedAndQueries());
            }
            case "nearestNeighbor": {
                String valuesStr = this.values.stream().map(i -> (String)i).collect(Collectors.joining(", "));
                return hasAnnotation ? Text.format("([%s]nearestNeighbor(%s, %s))", this.annotation, this.fieldName, valuesStr) : Text.format("nearestNeighbor(%s, %s)", this.fieldName, valuesStr);
            }
            case "fuzzy": {
                return Text.format("%s contains (%sfuzzy(%s))", this.fieldName, this.annotation, this.values.get(0));
            }
        }
        Object value = this.values.get(0);
        Object valuesStr = value instanceof Long ? String.valueOf(value) + "L" : value.toString();
        return hasAnnotation ? Text.format("%s %s ([%s]%s)", this.fieldName, this.relation, this.annotation, valuesStr) : Text.format("%s %s %s", this.fieldName, this.relation, valuesStr);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        return !"andnot".equals(this.op) && this.fieldName.equals(fieldName);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        return this.hasPositiveSearchField(fieldName) && this.valuesContains(value);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        return "andnot".equals(this.op) && this.fieldName.equals(fieldName);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        return this.hasNegativeSearchField(fieldName) && this.valuesContains(value);
    }

    boolean valuesContains(Object value) {
        if (value instanceof String) {
            value = "\"" + String.valueOf(value) + "\"";
        }
        return this.values.contains(value);
    }
}

