/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.FixedQuery;
import ai.vespa.client.dsl.Group;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Text;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EndQuery {
    QueryChain queryChain;
    Map<String, Integer> map = new LinkedHashMap<String, Integer>();
    List<Object[]> order = new ArrayList<Object[]>();
    String groupQueryStr;

    EndQuery(QueryChain queryChain) {
        this.queryChain = queryChain;
        this.map.put("limit", null);
        this.map.put("offset", null);
        this.map.put("timeout", null);
    }

    EndQuery setTimeout(Integer timeout) {
        this.map.put("timeout", timeout);
        return this;
    }

    EndQuery setOffset(int offset) {
        this.map.put("offset", offset);
        return this;
    }

    EndQuery setLimit(int limit) {
        this.map.put("limit", limit);
        return this;
    }

    public EndQuery offset(int offset) {
        return this.setOffset(offset);
    }

    public EndQuery timeout(int timeout) {
        return this.setTimeout(timeout);
    }

    public EndQuery limit(int limit) {
        return this.setLimit(limit);
    }

    public FixedQuery semicolon() {
        return new FixedQuery(this);
    }

    public EndQuery group(Group group) {
        this.groupQueryStr = group.toString();
        return this;
    }

    public EndQuery group(String groupQueryStr) {
        this.groupQueryStr = groupQueryStr;
        return this;
    }

    public EndQuery orderByAsc(Annotation annotation, String fieldName) {
        this.order.add(new Object[]{annotation, fieldName, "asc"});
        return this;
    }

    public EndQuery orderByAsc(String fieldName) {
        this.order.add(new Object[]{A.empty(), fieldName, "asc"});
        return this;
    }

    public EndQuery orderByDesc(Annotation annotation, String fieldName) {
        this.order.add(new Object[]{annotation, fieldName, "desc"});
        return this;
    }

    public EndQuery orderByDesc(String fieldName) {
        this.order.add(new Object[]{A.empty(), fieldName, "desc"});
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String orderStr = this.order.stream().map(array -> A.empty().equals(array[0]) ? Text.format("%s %s", array[1], array[2]) : Text.format("[%s]%s %s", array[0], array[1], array[2])).collect(Collectors.joining(", "));
        String others = this.map.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> (String)entry.getKey() + " " + entry.getValue()).collect(Collectors.joining(" "));
        if (orderStr.isEmpty()) {
            sb.append(others.isEmpty() ? "" : others);
        } else if (others.isEmpty()) {
            sb.append("order by ").append(orderStr);
        } else {
            sb.append("order by ").append(orderStr).append(" ").append(others);
        }
        if (this.groupQueryStr != null) {
            sb.append("| ").append(this.groupQueryStr);
        }
        return sb.toString();
    }
}

