/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Text;

public class NearestNeighbor
extends QueryChain {
    private Annotation annotation;
    private String docVectorName;
    private String queryVectorName;

    public NearestNeighbor(String docVectorName, String queryVectorName) {
        this.docVectorName = docVectorName;
        this.queryVectorName = queryVectorName;
        this.nonEmpty = true;
    }

    NearestNeighbor annotate(Annotation annotation) {
        this.annotation = annotation;
        return this;
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        return this.docVectorName.equals(fieldName);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        return this.docVectorName.equals(fieldName) && this.queryVectorName.equals(value);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        return false;
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        return false;
    }

    public String toString() {
        boolean hasAnnotation = A.hasAnnotation(this.annotation);
        if (!hasAnnotation || !this.annotation.contains("targetHits")) {
            throw new IllegalArgumentException("must specify target hits in nearest neighbor query");
        }
        String s = Text.format("nearestNeighbor(%s, %s)", this.docVectorName, this.queryVectorName);
        return Text.format("([%s]%s)", this.annotation, s);
    }
}

