/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.EndQuery;
import ai.vespa.client.dsl.Field;
import ai.vespa.client.dsl.Query;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Rank;
import ai.vespa.client.dsl.Select;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Sources {
    final Select select;
    final List<String> targetDocTypes;

    Sources(Select select, List<String> searchDefinitions) {
        this.select = select;
        this.targetDocTypes = new ArrayList<String>(searchDefinitions);
    }

    Sources(Select select, String searchDefinition) {
        this(select, Collections.singletonList(searchDefinition));
    }

    Sources(Select select, String searchDefinition, String ... others) {
        this(select, Stream.concat(Stream.of(searchDefinition), Stream.of(others)).collect(Collectors.toList()));
    }

    public String toString() {
        if (this.targetDocTypes.isEmpty() || this.targetDocTypes.size() == 1 && "*".equals(this.targetDocTypes.get(0))) {
            return "sources *";
        }
        if (this.targetDocTypes.size() == 1) {
            return this.targetDocTypes.get(0);
        }
        return "sources " + String.join((CharSequence)", ", this.targetDocTypes);
    }

    public Field where(String fieldName) {
        Field f = new Field(this, fieldName);
        f.setOp("and");
        return f;
    }

    public Query where(QueryChain userinput) {
        return this.whereReturnQuery(userinput);
    }

    public EndQuery where(Rank rank) {
        return this.whereReturnEndQuery(rank);
    }

    private Query whereReturnQuery(QueryChain qc) {
        return new Query(this, qc);
    }

    private EndQuery whereReturnEndQuery(Rank rank) {
        rank.setSources(this);
        return new EndQuery(rank);
    }
}

