/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generateSources", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateSourcesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Inject
    @Requirement
    private BuildPluginManager pluginManager;
    @Parameter
    protected String configGenVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String configGenVersion = this.getConfigGenVersion();
        this.getLog().debug((CharSequence)("configGenVersion = " + configGenVersion));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.yahoo.vespa"), (String)MojoExecutor.artifactId((String)"config-class-plugin"), (String)MojoExecutor.version((String)GenerateSourcesMojo.releaseVersion(configGenVersion))), (String)MojoExecutor.goal((String)"config-gen"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"defFilesDirectories"), (String)"src/main/resources/configdefinitions")}), (MojoExecutor.ExecutionEnvironment)this.createExecutionEnvironment());
        this.project.addCompileSourceRoot(this.project.getBuild().getDirectory() + "/generated-sources/vespa-configgen-plugin");
    }

    private MojoExecutor.ExecutionEnvironment createExecutionEnvironment() throws MojoExecutionException {
        return MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
    }

    private String getConfigGenVersion() throws MojoExecutionException {
        if (this.configGenVersion != null && !this.configGenVersion.isEmpty()) {
            return this.configGenVersion;
        }
        Dependency container = this.getVespaDependency("container");
        if (container != null) {
            return container.getVersion();
        }
        Dependency containerDev = this.getVespaDependency("container-dev");
        if (containerDev != null) {
            return containerDev.getVersion();
        }
        Dependency docproc = this.getVespaDependency("docproc");
        if (docproc != null) {
            return docproc.getVersion();
        }
        MavenProject parent = this.getVespaParent();
        if (parent != null) {
            return parent.getVersion();
        }
        String defaultConfigGenVersion = GenerateSourcesMojo.loadDefaultConfigGenVersion();
        this.getLog().warn((CharSequence)String.format("Did not find either container or container-dev artifact in project dependencies, using default version '%s' of the config class plugin.", defaultConfigGenVersion));
        return defaultConfigGenVersion;
    }

    static String loadDefaultConfigGenVersion() throws MojoExecutionException {
        Properties props = new Properties();
        try {
            props.load(GenerateSourcesMojo.class.getResourceAsStream("/build.properties"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to resolve version of com.yahoo.vespa:config-class-plugin.", (Exception)new FileNotFoundException("/build.properties"));
        }
        return props.getProperty("projectVersion");
    }

    private MavenProject getVespaParent() {
        MavenProject parent = this.project.getParent();
        if (parent != null && "com.yahoo.vespa".equals(parent.getGroupId()) && "parent".equals(parent.getArtifactId())) {
            return parent;
        }
        return null;
    }

    private Dependency getVespaDependency(String artifactId) {
        for (Object element : this.project.getDependencies()) {
            Dependency dependency = (Dependency)element;
            if (!"com.yahoo.vespa".equals(dependency.getGroupId()) || !artifactId.equals(dependency.getArtifactId())) continue;
            return dependency;
        }
        return null;
    }

    static String releaseVersion(String mavenVersion) {
        if (mavenVersion.endsWith("-SNAPSHOT")) {
            return mavenVersion;
        }
        String[] parts = mavenVersion.split(Pattern.quote("."));
        if (parts.length <= 3) {
            return mavenVersion;
        }
        return GenerateSourcesMojo.stringJoin(List.of(parts).subList(0, 3), ".");
    }

    static String stringJoin(Collection<String> elements, String sep) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> i = elements.iterator();
        if (i.hasNext()) {
            builder.append(i.next());
        }
        while (i.hasNext()) {
            builder.append(sep).append(i.next());
        }
        return builder.toString();
    }
}

