/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.util;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;

public class ArtifactId {
    private final String groupId;
    private final String artifactId;

    private ArtifactId(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public static ArtifactId fromArtifact(Artifact artifact) {
        return new ArtifactId(artifact.getGroupId(), artifact.getArtifactId());
    }

    public static ArtifactId fromStringValue(String stringValue) {
        String[] parts = stringValue.trim().split(":");
        if (parts.length == 2 || parts.length == 3) {
            return new ArtifactId(parts[0], parts[1]);
        }
        throw new IllegalArgumentException("An artifact should be represented in the format 'groupId:ArtifactId[:version]', not: " + stringValue);
    }

    public String stringValue() {
        return this.groupId + ":" + this.artifactId;
    }

    public String toString() {
        return this.stringValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactId that = (ArtifactId)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId);
    }
}

