/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.osgi;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ExportPackages {
    public static Map<String, Export> exportsByPackageName(Collection<Export> exports) {
        HashMap<String, Export> ret = new HashMap<String, Export>();
        for (Export export : exports) {
            for (String packageName : export.getPackageNames()) {
                ret.computeIfAbsent(packageName, ign -> export);
            }
        }
        return ret;
    }

    public static class Parameter {
        private final String name;
        private final String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Export {
        private final List<String> packageNames;
        private final List<Parameter> parameters;

        public Export(List<String> packageNames, List<Parameter> parameters) {
            this.packageNames = packageNames;
            this.parameters = parameters;
        }

        public Optional<String> version() {
            for (Parameter par : this.parameters) {
                if (!"version".equals(par.getName())) continue;
                return Optional.of(par.getValue());
            }
            return Optional.empty();
        }

        public List<String> getPackageNames() {
            return this.packageNames;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }
    }
}

