/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.yahoo.api.annotations.Beta;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.docproc.DocprocExecutor;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.docproc.Processing;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.processing.execution.chain.ChainRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Beta
public final class DocumentProcessing {
    private final DocumentProcessingHandler handler;
    private final Map<String, DocumentType> documentTypes;

    DocumentProcessing(DocumentProcessingHandler handler) {
        this.handler = handler;
        this.documentTypes = DocumentProcessing.retrieveDocumentTypes(handler.getDocumentTypeManager());
    }

    private static Map<String, DocumentType> retrieveDocumentTypes(DocumentTypeManager documentTypeManager) {
        HashMap<String, DocumentType> documentTypes = new HashMap<String, DocumentType>();
        Iterator i = documentTypeManager.documentTypeIterator();
        while (i.hasNext()) {
            DocumentType type = (DocumentType)i.next();
            documentTypes.put(type.getName(), type);
        }
        return Collections.unmodifiableMap(documentTypes);
    }

    public DocumentProcessor.Progress process(ComponentSpecification chain, Processing processing) {
        DocprocExecutor executor = this.getExecutor(chain);
        processing.setDocprocServiceRegistry(this.handler.getDocprocServiceRegistry());
        return executor.processUntilDone(processing);
    }

    public DocumentProcessor.Progress processOnce(ComponentSpecification chain, Processing processing) {
        DocprocExecutor executor = this.getExecutor(chain);
        processing.setDocprocServiceRegistry(this.handler.getDocprocServiceRegistry());
        return executor.process(processing);
    }

    private DocprocExecutor getExecutor(ComponentSpecification chain) {
        DocprocService service = (DocprocService)this.handler.getDocprocServiceRegistry().getComponent(chain);
        if (service == null) {
            throw new IllegalArgumentException("No such chain: " + chain);
        }
        return service.getExecutor();
    }

    public ChainRegistry<DocumentProcessor> getChains() {
        return this.handler.getChains();
    }

    public Map<String, DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public Map<String, AnnotationType> getAnnotationTypes() {
        return this.handler.getDocumentTypeManager().getAnnotationTypeRegistry().getTypes();
    }
}

