/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.google.common.annotations.Beta;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.yahoo.application.Networking;
import com.yahoo.application.container.DocumentProcessing;
import com.yahoo.application.container.Processing;
import com.yahoo.application.container.Search;
import com.yahoo.application.container.SynchronousRequestResponseHandler;
import com.yahoo.application.container.handler.Request;
import com.yahoo.application.container.handler.Response;
import com.yahoo.application.container.impl.ClassLoaderOsgiFramework;
import com.yahoo.application.container.impl.StandaloneContainerRunner;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.container.Container;
import com.yahoo.container.standalone.StandaloneContainerApplication;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.test.TestDriver;
import com.yahoo.processing.handler.ProcessingHandler;
import com.yahoo.search.handler.SearchHandler;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;

@Beta
public final class JDisc
implements AutoCloseable {
    private final ClassLoaderOsgiFramework osgiFramework = new ClassLoaderOsgiFramework();
    private final TestDriver testDriver;
    private final StandaloneContainerApplication application;
    private final Container container = Container.get();
    private final Path path;
    private final boolean deletePathWhenClosing;

    private JDisc(Path path, boolean deletePathWhenClosing, Networking networking, ConfigModelRepo configModelRepo) {
        this.path = path;
        this.deletePathWhenClosing = deletePathWhenClosing;
        this.testDriver = TestDriver.newInstance((OsgiFramework)this.osgiFramework, (String)"", (boolean)false, (Module[])new Module[]{this.bindings(path, configModelRepo, networking)});
        this.application = (StandaloneContainerApplication)this.testDriver.application();
    }

    private Module bindings(final Path path, final ConfigModelRepo configModelRepo, final Networking networking) {
        return new AbstractModule(){

            protected void configure() {
                this.bind(Path.class).annotatedWith((Annotation)StandaloneContainerApplication.APPLICATION_PATH_NAME).toInstance((Object)path);
                this.bind(ConfigModelRepo.class).annotatedWith((Annotation)StandaloneContainerApplication.CONFIG_MODEL_REPO_NAME).toInstance((Object)configModelRepo);
                this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"JDisc.disableNetworking")).toInstance((Object)(networking == Networking.disable ? 1 : 0));
            }
        };
    }

    public static JDisc fromServicesXml(String xml, Networking networking) {
        Path applicationDir = StandaloneContainerRunner.createApplicationPackage((String)xml);
        return new JDisc(applicationDir, true, networking, new ConfigModelRepo());
    }

    public static JDisc fromPath(Path path, Networking networking) {
        return new JDisc(path, false, networking, new ConfigModelRepo());
    }

    public static JDisc fromPath(Path path, Networking networking, ConfigModelRepo configModelRepo) {
        return new JDisc(path, false, networking, configModelRepo);
    }

    public Search search() {
        SearchHandler searchHandler = this.getSearchHandler();
        if (searchHandler == null) {
            throw new UnsupportedOperationException("This JDisc does not have 'search' configured.");
        }
        return new Search(searchHandler);
    }

    private SearchHandler getSearchHandler() {
        for (RequestHandler h : this.container.getRequestHandlerRegistry().allComponents()) {
            if (!(h instanceof SearchHandler)) continue;
            return (SearchHandler)h;
        }
        return null;
    }

    public Processing processing() {
        ProcessingHandler processingHandler = (ProcessingHandler)this.container.getRequestHandlerRegistry().getComponent(ProcessingHandler.class.getName());
        if (processingHandler == null) {
            throw new UnsupportedOperationException("This JDisc does not have 'processing' configured.");
        }
        return new Processing(processingHandler);
    }

    public DocumentProcessing documentProcessing() {
        DocumentProcessingHandler docprocHandler = (DocumentProcessingHandler)this.container.getRequestHandlerRegistry().getComponent(DocumentProcessingHandler.class.getName());
        if (docprocHandler == null) {
            throw new UnsupportedOperationException("This JDisc does not have 'document-processing' configured.");
        }
        return new DocumentProcessing(docprocHandler);
    }

    public ComponentRegistry<AbstractComponent> components() {
        return this.container.getComponentRegistry();
    }

    public Response handleRequest(Request request) {
        SynchronousRequestResponseHandler handler = new SynchronousRequestResponseHandler();
        return handler.handleRequest(request, this.testDriver);
    }

    @Override
    public void close() {
        try {
            this.testDriver.close();
        }
        finally {
            Container.resetInstance();
            if (this.deletePathWhenClosing) {
                IOUtils.recursiveDeleteDir((File)this.path.toFile());
            }
        }
    }
}

