/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.abicheck.setmatcher;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SetMatcher {
    public static <T> boolean compare(Set<T> expected, Set<T> actual, Predicate<T> itemsMatch, Consumer<T> onMissing, Consumer<T> onExtra) {
        boolean mismatch = false;
        HashSet<T> missing = new HashSet<T>(expected);
        missing.removeIf(actual::contains);
        for (Object item : missing) {
            mismatch = true;
            onMissing.accept(item);
        }
        HashSet<T> extra = new HashSet<T>(actual);
        extra.removeIf(expected::contains);
        for (Object item : extra) {
            mismatch = true;
            onExtra.accept(item);
        }
        HashSet<T> both = new HashSet<T>(actual);
        both.removeIf(Predicate.not(expected::contains));
        for (Object item : both) {
            if (itemsMatch.test(item)) continue;
            mismatch = true;
        }
        return !mismatch;
    }
}

