/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.HashMapDataStore;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MetaDataStoreTransaction
implements DataStoreTransaction {
    private static final Function<String, HashMapDataStore> REQUEST_ERROR = key -> {
        throw new BadRequestException("API version " + key + " not found");
    };
    private final Map<String, HashMapDataStore> hashMapDataStores;
    private final Map<String, DataStoreTransaction> transactions = new HashMap<String, DataStoreTransaction>();

    public MetaDataStoreTransaction(Map<String, HashMapDataStore> hashMapDataStores) {
        this.hashMapDataStores = hashMapDataStores;
    }

    public void flush(RequestScope requestScope) {
    }

    public void save(Object object, RequestScope requestScope) {
        throw new InvalidOperationException("save not supported for metadatastore");
    }

    public void delete(Object object, RequestScope requestScope) {
        throw new InvalidOperationException("delete not supported for metadatastore");
    }

    public void commit(RequestScope scope) {
    }

    public void createObject(Object entity, RequestScope scope) {
    }

    public DataStoreIterable<Object> getToManyRelation(DataStoreTransaction relationTx, Object entity, Relationship relationship, RequestScope scope) {
        DataStoreTransaction dataStoreTransaction = this.getTransaction(scope);
        return dataStoreTransaction.getToManyRelation(relationTx, entity, relationship, scope);
    }

    public Object getToOneRelation(DataStoreTransaction relationTx, Object entity, Relationship relationship, RequestScope scope) {
        DataStoreTransaction dataStoreTransaction = this.getTransaction(scope);
        return dataStoreTransaction.getToOneRelation(relationTx, entity, relationship, scope);
    }

    public DataStoreIterable<Object> loadObjects(EntityProjection projection, RequestScope scope) {
        DataStoreTransaction dataStoreTransaction = this.getTransaction(scope);
        return dataStoreTransaction.loadObjects(projection, scope);
    }

    public Object loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        DataStoreTransaction dataStoreTransaction = this.getTransaction(scope);
        return dataStoreTransaction.loadObject(projection, id, scope);
    }

    protected DataStoreTransaction getTransaction(RequestScope scope) {
        DataStore dataStore = (DataStore)this.hashMapDataStores.computeIfAbsent(scope.getRoute().getApiVersion(), REQUEST_ERROR);
        return this.transactions.computeIfAbsent(scope.getRoute().getApiVersion(), key -> dataStore.beginReadTransaction());
    }

    public void close() throws IOException {
        IOException exception = null;
        for (DataStoreTransaction transaction : this.transactions.values()) {
            try {
                transaction.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = new IOException(e);
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        this.transactions.clear();
        if (exception != null) {
            throw exception;
        }
    }

    public void cancel(RequestScope scope) {
    }
}

