/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.query;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.PredicateExtractionVisitor;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.metadata.ColumnContext;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.TableContext;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.ImmutablePagination;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.QueryVisitor;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromSubquery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.annotation.FromTable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.JoinExpressionExtractor;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.NativeQuery;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLMetricProjection;
import com.yahoo.elide.datastores.jpql.filter.FilterTranslator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryTranslator
implements QueryVisitor<NativeQuery.NativeQueryBuilder> {
    private final MetaDataStore metaDataStore;
    private final EntityDictionary dictionary;
    private final SQLDialect dialect;
    private FilterTranslator filterTranslator;
    private final ExpressionParser parser;
    private final Query clientQuery;

    public QueryTranslator(MetaDataStore metaDataStore, SQLDialect sqlDialect, Query clientQuery) {
        this.metaDataStore = metaDataStore;
        this.dictionary = metaDataStore.getMetadataDictionary();
        this.dialect = sqlDialect;
        this.filterTranslator = new FilterTranslator(this.dictionary, sqlDialect.getPredicateGeneratorOverrides());
        this.parser = new ExpressionParser(metaDataStore);
        this.clientQuery = clientQuery;
    }

    @Override
    public NativeQuery.NativeQueryBuilder visitQuery(Query query) {
        ImmutablePagination pagination;
        NativeQuery.NativeQueryBuilder builder = query.getSource().accept(this);
        if (query.isNested()) {
            NativeQuery innerQuery = builder.build();
            builder = NativeQuery.builder().fromClause(QueryTranslator.getFromClause("(" + innerQuery + ")", this.applyQuotes(query.getSource().getAlias()), this.dialect));
        }
        LinkedHashSet<String> joinExpressions = new LinkedHashSet<String>();
        builder.projectionClause(this.constructProjectionWithReference(query));
        joinExpressions.addAll(this.extractJoinExpressions(query));
        Set groupByDimensions = query.getAllDimensionProjections().stream().map(SQLColumnProjection.class::cast).filter(ColumnProjection::isProjected).collect(Collectors.toCollection(LinkedHashSet::new));
        if (!groupByDimensions.isEmpty() && !query.getMetricProjections().isEmpty()) {
            builder.groupByClause("GROUP BY " + groupByDimensions.stream().map(SQLColumnProjection.class::cast).map(column -> column.toSQL(query, this.metaDataStore)).collect(Collectors.joining(", ")));
        }
        if (query.getWhereFilter() != null) {
            builder.whereClause("WHERE " + this.translateFilterExpression(query.getWhereFilter(), path -> this.generatePredicatePathReference((Path)path, query)));
            joinExpressions.addAll(this.extractJoinExpressions(query, query.getWhereFilter()));
        }
        if (query.getHavingFilter() != null) {
            builder.havingClause("HAVING " + this.translateFilterExpression(query.getHavingFilter(), path -> this.constructHavingClauseWithReference((Path)path, query)));
            joinExpressions.addAll(this.extractJoinExpressions(query, query.getHavingFilter()));
        }
        if (query.getSorting() != null) {
            Map sortClauses = query.getSorting().getSortingPaths();
            builder.orderByClause(this.extractOrderBy(sortClauses, query));
            joinExpressions.addAll(this.extractJoinExpressions(query, sortClauses));
        }
        if ((pagination = query.getPagination()) != null) {
            builder.offsetLimitClause(this.dialect.generateOffsetLimitClause(pagination.getOffset(), pagination.getLimit()));
        }
        return builder.joinClause(String.join((CharSequence)" ", joinExpressions));
    }

    @Override
    public NativeQuery.NativeQueryBuilder visitQueryable(Queryable table) {
        NativeQuery.NativeQueryBuilder builder = NativeQuery.builder();
        Type tableCls = this.dictionary.getEntityClass(table.getName(), table.getVersion());
        String tableAlias = this.applyQuotes(table.getAlias());
        TableContext context = TableContext.builder().tableArguments(this.clientQuery.getArguments()).build();
        Object tableStatement = tableCls.isAnnotationPresent(FromSubquery.class) ? "(" + context.resolve(((FromSubquery)tableCls.getAnnotation(FromSubquery.class)).sql()) + ")" : (tableCls.isAnnotationPresent(FromTable.class) ? this.applyQuotes(((FromTable)tableCls.getAnnotation(FromTable.class)).name()) : this.applyQuotes(table.getName()));
        return builder.fromClause(QueryTranslator.getFromClause((String)tableStatement, tableAlias, this.dialect));
    }

    private String constructHavingClauseWithReference(Path path, Query query) {
        Path.PathElement last = (Path.PathElement)path.lastElement().get();
        String fieldName = last.getFieldName();
        if (path.getPathElements().size() > 1) {
            throw new BadRequestException("The having clause can only reference fact table aggregations.");
        }
        SQLMetricProjection metric = query.getMetricProjections().stream().map(SQLMetricProjection.class::cast).filter(invocation -> invocation.getAlias().equals(fieldName)).findFirst().orElse(null);
        if (metric != null) {
            return metric.toSQL(query, this.metaDataStore);
        }
        return this.generatePredicatePathReference(path, query);
    }

    private String constructProjectionWithReference(Query query) {
        List metricProjections = query.getMetricProjections().stream().map(SQLMetricProjection.class::cast).filter(ColumnProjection::isProjected).filter(projection -> !projection.getValueType().equals((Object)ValueType.ID)).map(invocation -> invocation.toSQL(query, this.metaDataStore) + " AS " + this.applyQuotes(invocation.getSafeAlias())).collect(Collectors.toList());
        List dimensionProjections = query.getAllDimensionProjections().stream().map(SQLColumnProjection.class::cast).filter(ColumnProjection::isProjected).map(dimension -> dimension.toSQL(query, this.metaDataStore) + " AS " + this.applyQuotes(dimension.getSafeAlias())).collect(Collectors.toList());
        if (metricProjections.isEmpty()) {
            return "DISTINCT " + String.join((CharSequence)",", dimensionProjections);
        }
        return Stream.concat(metricProjections.stream(), dimensionProjections.stream()).collect(Collectors.joining(","));
    }

    private String extractOrderBy(Map<Path, Sorting.SortOrder> sortClauses, Query query) {
        if (sortClauses.isEmpty()) {
            return "";
        }
        return " ORDER BY " + sortClauses.entrySet().stream().map(entry -> {
            Path path = (Path)entry.getKey();
            Sorting.SortOrder order = (Sorting.SortOrder)entry.getValue();
            Path.PathElement last = (Path.PathElement)path.lastElement().get();
            SQLColumnProjection projection = this.fieldToColumnProjection(query, last.getAlias());
            String orderByClause = query.getColumnProjections().contains(projection) && this.dialect.useAliasForOrderByClause() ? this.applyQuotes(projection.getSafeAlias()) : projection.toSQL(query, this.metaDataStore);
            return orderByClause + (order.equals((Object)Sorting.SortOrder.desc) ? " DESC" : " ASC");
        }).collect(Collectors.joining(","));
    }

    private Set<String> extractJoinExpressions(Query query, Path path) {
        SQLColumnProjection columnProj = this.pathToColumnProjection(path, query);
        return this.extractJoinExpressions(columnProj, query);
    }

    private Set<String> extractJoinExpressions(Query query, FilterExpression expression) {
        Collection predicates = (Collection)expression.accept((FilterExpressionVisitor)new PredicateExtractionVisitor());
        return predicates.stream().map(FilterPredicate::getPath).map(path -> this.extractJoinExpressions(query, (Path)path)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<String> extractJoinExpressions(Query query, Map<Path, Sorting.SortOrder> sortClauses) {
        return sortClauses.keySet().stream().map(path -> this.extractJoinExpressions(query, (Path)path)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<String> extractJoinExpressions(Query query) {
        return query.getColumnProjections().stream().filter(column -> column.isProjected()).map(column -> this.extractJoinExpressions((ColumnProjection)column, query)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<String> extractJoinExpressions(ColumnProjection column, Query query) {
        LinkedHashSet<String> joinExpressions = new LinkedHashSet<String>();
        ColumnContext context = ColumnContext.builder().queryable(query).alias(query.getSource().getAlias()).metaDataStore(this.metaDataStore).column(column).tableArguments(query.getArguments()).build();
        JoinExpressionExtractor visitor = new JoinExpressionExtractor(context);
        List<Reference> references = this.parser.parse(query.getSource(), column);
        references.forEach(ref -> joinExpressions.addAll((Collection)ref.accept(visitor)));
        return joinExpressions;
    }

    private String translateFilterExpression(FilterExpression expression, Function<Path, String> aliasGenerator) {
        return this.filterTranslator.apply(expression, aliasGenerator);
    }

    private String generatePredicatePathReference(Path path, Query query) {
        SQLColumnProjection projection = this.pathToColumnProjection(path, query);
        return projection.toSQL(query, this.metaDataStore);
    }

    private SQLColumnProjection pathToColumnProjection(Path path, Query query) {
        Path.PathElement last = (Path.PathElement)path.lastElement().get();
        Map<String, Argument> arguments = last.getArguments().stream().collect(Collectors.toMap(Argument::getName, Function.identity()));
        return this.fieldToColumnProjection(query, last.getAlias(), arguments);
    }

    private SQLColumnProjection fieldToColumnProjection(Query query, String fieldName) {
        ColumnProjection projection = query.getColumnProjection(fieldName);
        if (projection == null) {
            projection = query.getSource().getColumnProjection(fieldName);
        }
        return (SQLColumnProjection)projection;
    }

    private SQLColumnProjection fieldToColumnProjection(Query query, String fieldName, Map<String, Argument> arguments) {
        ColumnProjection projection = query.getColumnProjection(fieldName, arguments);
        if (projection == null) {
            projection = query.getSource().getColumnProjection(fieldName, arguments);
        }
        return (SQLColumnProjection)projection;
    }

    private String applyQuotes(String str) {
        return ColumnContext.applyQuotes(str, this.dialect);
    }

    public static String getFromClause(String fromStatement, String fromAlias, SQLDialect sqlDialect) {
        if (sqlDialect.useASBeforeTableAlias()) {
            return String.format("%s AS %s", fromStatement, fromAlias);
        }
        return String.format("%s %s", fromStatement, fromAlias);
    }
}

