/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata;

import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.annotation.JoinType;

public final class SQLJoin {
    private final String name;
    private final JoinType joinType;
    private final boolean toOne;
    private final Type<?> joinTableType;
    private final String joinExpression;

    SQLJoin(String name, JoinType joinType, boolean toOne, Type<?> joinTableType, String joinExpression) {
        this.name = name;
        this.joinType = joinType;
        this.toOne = toOne;
        this.joinTableType = joinTableType;
        this.joinExpression = joinExpression;
    }

    public static SQLJoinBuilder builder() {
        return new SQLJoinBuilder();
    }

    public String getName() {
        return this.name;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public boolean isToOne() {
        return this.toOne;
    }

    public Type<?> getJoinTableType() {
        return this.joinTableType;
    }

    public String getJoinExpression() {
        return this.joinExpression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLJoin)) {
            return false;
        }
        SQLJoin other = (SQLJoin)o;
        if (this.isToOne() != other.isToOne()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        JoinType this$joinType = this.getJoinType();
        JoinType other$joinType = other.getJoinType();
        if (this$joinType == null ? other$joinType != null : !((Object)((Object)this$joinType)).equals((Object)other$joinType)) {
            return false;
        }
        Type<?> this$joinTableType = this.getJoinTableType();
        Type<?> other$joinTableType = other.getJoinTableType();
        if (this$joinTableType == null ? other$joinTableType != null : !this$joinTableType.equals(other$joinTableType)) {
            return false;
        }
        String this$joinExpression = this.getJoinExpression();
        String other$joinExpression = other.getJoinExpression();
        return !(this$joinExpression == null ? other$joinExpression != null : !this$joinExpression.equals(other$joinExpression));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isToOne() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        JoinType $joinType = this.getJoinType();
        result = result * 59 + ($joinType == null ? 43 : ((Object)((Object)$joinType)).hashCode());
        Type<?> $joinTableType = this.getJoinTableType();
        result = result * 59 + ($joinTableType == null ? 43 : $joinTableType.hashCode());
        String $joinExpression = this.getJoinExpression();
        result = result * 59 + ($joinExpression == null ? 43 : $joinExpression.hashCode());
        return result;
    }

    public String toString() {
        return "SQLJoin(name=" + this.getName() + ", joinType=" + this.getJoinType() + ", toOne=" + this.isToOne() + ", joinTableType=" + this.getJoinTableType() + ", joinExpression=" + this.getJoinExpression() + ")";
    }

    public static class SQLJoinBuilder {
        private String name;
        private JoinType joinType;
        private boolean toOne;
        private Type<?> joinTableType;
        private String joinExpression;

        SQLJoinBuilder() {
        }

        public SQLJoinBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SQLJoinBuilder joinType(JoinType joinType) {
            this.joinType = joinType;
            return this;
        }

        public SQLJoinBuilder toOne(boolean toOne) {
            this.toOne = toOne;
            return this;
        }

        public SQLJoinBuilder joinTableType(Type<?> joinTableType) {
            this.joinTableType = joinTableType;
            return this;
        }

        public SQLJoinBuilder joinExpression(String joinExpression) {
            this.joinExpression = joinExpression;
            return this;
        }

        public SQLJoin build() {
            return new SQLJoin(this.name, this.joinType, this.toOne, this.joinTableType, this.joinExpression);
        }

        public String toString() {
            return "SQLJoin.SQLJoinBuilder(name=" + this.name + ", joinType=" + this.joinType + ", toOne=" + this.toOne + ", joinTableType=" + this.joinTableType + ", joinExpression=" + this.joinExpression + ")";
        }
    }
}

