/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.google.common.base.Preconditions;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Dimension;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;

@Include(rootLevel=false, name="tableSource")
public class TableSource {
    @Id
    private String id;
    @OneToOne
    private Column valueSource;
    @ManyToMany
    Set<Column> suggestionColumns;

    public TableSource(Column valueSource, Set<Column> suggestionColumns) {
        this.id = valueSource.getId();
        this.valueSource = valueSource;
        this.suggestionColumns = suggestionColumns;
    }

    public static TableSource fromDefinition(com.yahoo.elide.datastores.aggregation.annotation.TableSource sourceDefinition, String apiVersion, MetaDataStore metaDataStore) {
        if (sourceDefinition == null || sourceDefinition.table() == null || sourceDefinition.table().isEmpty()) {
            return null;
        }
        String sourceModelName = com.yahoo.elide.modelconfig.model.Table.getModelName((String)sourceDefinition.table(), (String)sourceDefinition.namespace());
        Table sourceTable = metaDataStore.getTable(sourceModelName, apiVersion);
        Preconditions.checkNotNull((Object)sourceTable, (Object)("Unable to locate table Source table: " + sourceModelName));
        Dimension sourceColumn = sourceTable.getDimension(sourceDefinition.column());
        Preconditions.checkNotNull((Object)sourceColumn, (Object)("Unable to locate table Source column: " + sourceDefinition.column()));
        HashSet<Column> suggestionColumns = new HashSet<Column>();
        if (sourceDefinition.suggestionColumns().length > 0) {
            for (int idx = 0; idx < sourceDefinition.suggestionColumns().length; ++idx) {
                String suggestionColumnName = sourceDefinition.suggestionColumns()[idx];
                Dimension suggestionColumn = sourceTable.getDimension(suggestionColumnName);
                Preconditions.checkNotNull((Object)sourceTable, (Object)("Unable to locate table suggestion column: " + suggestionColumnName));
                suggestionColumns.add(suggestionColumn);
            }
        }
        return new TableSource(sourceColumn, suggestionColumns);
    }

    public String getId() {
        return this.id;
    }

    public Column getValueSource() {
        return this.valueSource;
    }

    public Set<Column> getSuggestionColumns() {
        return this.suggestionColumns;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setValueSource(Column valueSource) {
        this.valueSource = valueSource;
    }

    public void setSuggestionColumns(Set<Column> suggestionColumns) {
        this.suggestionColumns = suggestionColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableSource)) {
            return false;
        }
        TableSource other = (TableSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Column this$valueSource = this.getValueSource();
        Column other$valueSource = other.getValueSource();
        if (this$valueSource == null ? other$valueSource != null : !((Object)this$valueSource).equals(other$valueSource)) {
            return false;
        }
        Set<Column> this$suggestionColumns = this.getSuggestionColumns();
        Set<Column> other$suggestionColumns = other.getSuggestionColumns();
        return !(this$suggestionColumns == null ? other$suggestionColumns != null : !((Object)this$suggestionColumns).equals(other$suggestionColumns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Column $valueSource = this.getValueSource();
        result = result * 59 + ($valueSource == null ? 43 : ((Object)$valueSource).hashCode());
        Set<Column> $suggestionColumns = this.getSuggestionColumns();
        result = result * 59 + ($suggestionColumns == null ? 43 : ((Object)$suggestionColumns).hashCode());
        return result;
    }

    public String toString() {
        return "TableSource(id=" + this.getId() + ", valueSource=" + this.getValueSource() + ", suggestionColumns=" + this.getSuggestionColumns() + ")";
    }
}

