/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.expression;

import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.Reference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ReferenceVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public final class LogicalReference
implements Reference {
    private final List<Reference> references;
    @NonNull
    private final Queryable source;
    @NonNull
    private final ColumnProjection column;

    @Override
    public <T> T accept(ReferenceVisitor<T> visitor) {
        return visitor.visitLogicalReference(this);
    }

    LogicalReference(List<Reference> references, @NonNull Queryable source, @NonNull ColumnProjection column) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        this.references = references;
        this.source = source;
        this.column = column;
    }

    public static LogicalReferenceBuilder builder() {
        return new LogicalReferenceBuilder();
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    @NonNull
    public Queryable getSource() {
        return this.source;
    }

    @NonNull
    public ColumnProjection getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogicalReference)) {
            return false;
        }
        LogicalReference other = (LogicalReference)o;
        List<Reference> this$references = this.getReferences();
        List<Reference> other$references = other.getReferences();
        if (this$references == null ? other$references != null : !((Object)this$references).equals(other$references)) {
            return false;
        }
        Queryable this$source = this.getSource();
        Queryable other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        ColumnProjection this$column = this.getColumn();
        ColumnProjection other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !((Object)this$column).equals(other$column));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Reference> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        Queryable $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        ColumnProjection $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
        return result;
    }

    public String toString() {
        return "LogicalReference(references=" + this.getReferences() + ", source=" + this.getSource() + ", column=" + this.getColumn() + ")";
    }

    public static class LogicalReferenceBuilder {
        private ArrayList<Reference> references;
        private Queryable source;
        private ColumnProjection column;

        LogicalReferenceBuilder() {
        }

        public LogicalReferenceBuilder reference(Reference reference) {
            if (this.references == null) {
                this.references = new ArrayList();
            }
            this.references.add(reference);
            return this;
        }

        public LogicalReferenceBuilder references(Collection<? extends Reference> references) {
            if (references == null) {
                throw new NullPointerException("references cannot be null");
            }
            if (this.references == null) {
                this.references = new ArrayList();
            }
            this.references.addAll(references);
            return this;
        }

        public LogicalReferenceBuilder clearReferences() {
            if (this.references != null) {
                this.references.clear();
            }
            return this;
        }

        public LogicalReferenceBuilder source(@NonNull Queryable source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        public LogicalReferenceBuilder column(@NonNull ColumnProjection column) {
            if (column == null) {
                throw new NullPointerException("column is marked non-null but is null");
            }
            this.column = column;
            return this;
        }

        public LogicalReference build() {
            List<Reference> references;
            switch (this.references == null ? 0 : this.references.size()) {
                case 0: {
                    references = Collections.emptyList();
                    break;
                }
                case 1: {
                    references = Collections.singletonList(this.references.get(0));
                    break;
                }
                default: {
                    references = Collections.unmodifiableList(new ArrayList<Reference>(this.references));
                }
            }
            return new LogicalReference(references, this.source, this.column);
        }

        public String toString() {
            return "LogicalReference.LogicalReferenceBuilder(references=" + this.references + ", source=" + this.source + ", column=" + this.column + ")";
        }
    }
}

