/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite;

import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.CalciteUtils;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.SupportedAggregation;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.SupportedOperation;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;

public class SyntaxVerifier
extends SqlBasicVisitor<Boolean> {
    private SQLDialect dialect;
    private String lastError;

    public SyntaxVerifier(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public boolean verify(String expression) {
        SqlNode node;
        SqlParser sqlParser = SqlParser.create((String)expression, (SqlParser.Config)CalciteUtils.constructParserConfig(this.dialect));
        try {
            node = sqlParser.parseExpression();
        }
        catch (SqlParseException e) {
            this.lastError = e.getMessage();
            return false;
        }
        return (Boolean)node.accept((SqlVisitor)this);
    }

    public Boolean visit(SqlLiteral literal) {
        return true;
    }

    public Boolean visit(SqlCall call) {
        SupportedOperation operator;
        String operatorName = call.getOperator().getName();
        SupportedAggregation aggregation = this.dialect.getSupportedAggregation(operatorName);
        if (aggregation == null && (operator = this.dialect.getSupportedOperation(operatorName)) == null) {
            this.lastError = "Unknown operator: " + operatorName;
            return false;
        }
        boolean result = true;
        for (int idx = 0; idx < call.getOperandList().size(); ++idx) {
            SqlNode operand = (SqlNode)call.getOperandList().get(idx);
            if (operand == null) continue;
            result &= ((Boolean)operand.accept((SqlVisitor)this)).booleanValue();
        }
        return result;
    }

    public Boolean visit(SqlNodeList nodeList) {
        return true;
    }

    public Boolean visit(SqlIdentifier id) {
        return true;
    }

    public Boolean visit(SqlDataTypeSpec type) {
        return true;
    }

    public Boolean visit(SqlDynamicParam param) {
        return true;
    }

    public Boolean visit(SqlIntervalQualifier intervalQualifier) {
        return true;
    }

    public String getLastError() {
        return this.lastError;
    }
}

