/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.ParameterizedModel;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.datastores.aggregation.metadata.enums.ValueType;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.Query;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLColumnProjection;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.query.SQLMetricProjection;
import com.yahoo.elide.datastores.aggregation.timegrains.Day;
import com.yahoo.elide.datastores.aggregation.timegrains.Hour;
import com.yahoo.elide.datastores.aggregation.timegrains.ISOWeek;
import com.yahoo.elide.datastores.aggregation.timegrains.Minute;
import com.yahoo.elide.datastores.aggregation.timegrains.Month;
import com.yahoo.elide.datastores.aggregation.timegrains.Quarter;
import com.yahoo.elide.datastores.aggregation.timegrains.Second;
import com.yahoo.elide.datastores.aggregation.timegrains.Week;
import com.yahoo.elide.datastores.aggregation.timegrains.Year;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHydrator
implements Iterable<Object> {
    private static final Logger log = LoggerFactory.getLogger(EntityHydrator.class);
    private final EntityDictionary entityDictionary;
    private final Query query;
    private ResultSet resultSet;
    private Map<String, String> projections;

    public EntityHydrator(ResultSet resultSet, Query query, EntityDictionary entityDictionary) {
        this.query = query;
        this.entityDictionary = entityDictionary;
        this.resultSet = resultSet;
        this.projections = this.query.getMetricProjections().stream().map(SQLMetricProjection.class::cast).filter(ColumnProjection::isProjected).filter(projection -> !projection.getValueType().equals((Object)ValueType.ID)).collect(Collectors.toMap(ColumnProjection::getAlias, ColumnProjection::getSafeAlias));
        this.projections.putAll(this.query.getAllDimensionProjections().stream().map(SQLColumnProjection.class::cast).filter(ColumnProjection::isProjected).collect(Collectors.toMap(ColumnProjection::getAlias, ColumnProjection::getSafeAlias)));
    }

    protected Object coerceObjectToEntity(Map<String, Object> result, MutableInt counter) {
        Object entityInstance;
        Table table = this.getBaseTable(this.query);
        Type entityClass = this.entityDictionary.getEntityClass(table.getName(), table.getVersion());
        try {
            entityInstance = entityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
        result.forEach((? super K fieldName, ? super V value) -> {
            ColumnProjection columnProjection = this.query.getColumnProjection((String)fieldName);
            Column column = table.getColumn(Column.class, columnProjection.getName());
            Type fieldType = this.getType(entityClass, columnProjection);
            Attribute attribute = this.projectionToAttribute(columnProjection, fieldType);
            ValueType valueType = column.getValueType();
            if (entityInstance instanceof ParameterizedModel) {
                if (!fieldType.isEnum() && valueType == ValueType.TEXT && column.getValues() != null && !column.getValues().isEmpty()) {
                    value = this.convertToEnumValue(value, column.getValues());
                }
                ((ParameterizedModel)entityInstance).addAttributeValue(attribute, CoerceUtil.coerce((Object)value, (Type)fieldType));
            } else {
                this.getEntityDictionary().setValue(entityInstance, fieldName, value);
            }
        });
        this.getEntityDictionary().setValue(entityInstance, this.getEntityDictionary().getIdFieldName(entityClass), (Object)counter.getAndIncrement());
        return entityInstance;
    }

    private Table getBaseTable(Query query) {
        Queryable next = query;
        while (next.isNested()) {
            next = next.getSource();
        }
        return (Table)((Object)next.getSource());
    }

    private Attribute projectionToAttribute(ColumnProjection projection, Type valueType) {
        return Attribute.builder().alias(projection.getAlias()).name(projection.getName()).arguments(projection.getArguments().values()).type(valueType).build();
    }

    private Type getType(Type modelType, ColumnProjection column) {
        if (!(column instanceof TimeDimensionProjection)) {
            return this.entityDictionary.getType(modelType, column.getName());
        }
        switch (((TimeDimensionProjection)column).getGrain()) {
            case SECOND: {
                return ClassType.of(Second.class);
            }
            case MINUTE: {
                return ClassType.of(Minute.class);
            }
            case HOUR: {
                return ClassType.of(Hour.class);
            }
            case DAY: {
                return ClassType.of(Day.class);
            }
            case ISOWEEK: {
                return ClassType.of(ISOWeek.class);
            }
            case WEEK: {
                return ClassType.of(Week.class);
            }
            case MONTH: {
                return ClassType.of(Month.class);
            }
            case QUARTER: {
                return ClassType.of(Quarter.class);
            }
            case YEAR: {
                return ClassType.of(Year.class);
            }
        }
        throw new IllegalStateException("Invalid grain type");
    }

    private String convertToEnumValue(Object value, LinkedHashSet<String> enumValues) {
        if (value == null) {
            return null;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            Integer valueIndex = (Integer)value;
            if (valueIndex < enumValues.size()) {
                return enumValues.toArray(new String[0])[valueIndex];
            }
        } else if (enumValues.contains(value.toString())) {
            return value.toString();
        }
        throw new InvalidValueException(value, "Value must map to a value in: " + enumValues);
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            Object next = null;
            MutableInt counter = new MutableInt(0);

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = this.next();
                    }
                    catch (NoSuchElementException e) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object next() {
                if (this.next != null) {
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
                try {
                    boolean hasNext = EntityHydrator.this.resultSet.next();
                    if (!hasNext) {
                        throw new NoSuchElementException();
                    }
                    LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                    for (Map.Entry<String, String> entry : EntityHydrator.this.projections.entrySet()) {
                        Object value = EntityHydrator.this.resultSet.getObject(entry.getValue());
                        row.put(entry.getKey(), value);
                    }
                    return EntityHydrator.this.coerceObjectToEntity(row, this.counter);
                }
                catch (SQLException e) {
                    log.error("Error iterating over results {}", (Object)e.getMessage());
                    throw new NoSuchElementException();
                }
            }
        };
    }

    protected EntityDictionary getEntityDictionary() {
        return this.entityDictionary;
    }

    private Query getQuery() {
        return this.query;
    }
}

