/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.yahoo.elide.core.request.Pagination;

public final class ImmutablePagination
implements Pagination {
    private final int offset;
    private final int limit;
    private final boolean defaultInstance;
    private final boolean returnPageTotals;

    public static ImmutablePagination from(Pagination src) {
        if (src instanceof ImmutablePagination) {
            return (ImmutablePagination)src;
        }
        if (src != null) {
            return new ImmutablePagination(src.getOffset(), src.getLimit(), src.isDefaultInstance(), src.returnPageTotals());
        }
        return null;
    }

    public boolean returnPageTotals() {
        return this.returnPageTotals;
    }

    public Long getPageTotals() {
        return null;
    }

    public void setPageTotals(Long pageTotals) {
        throw new UnsupportedOperationException("ImmutablePagination does not support setPageTotals");
    }

    public ImmutablePagination(int offset, int limit, boolean defaultInstance, boolean returnPageTotals) {
        this.offset = offset;
        this.limit = limit;
        this.defaultInstance = defaultInstance;
        this.returnPageTotals = returnPageTotals;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    public boolean isReturnPageTotals() {
        return this.returnPageTotals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutablePagination)) {
            return false;
        }
        ImmutablePagination other = (ImmutablePagination)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.isDefaultInstance() != other.isDefaultInstance()) {
            return false;
        }
        return this.isReturnPageTotals() == other.isReturnPageTotals();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        result = result * 59 + (this.isDefaultInstance() ? 79 : 97);
        result = result * 59 + (this.isReturnPageTotals() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ImmutablePagination(offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", defaultInstance=" + this.isDefaultInstance() + ", returnPageTotals=" + this.isReturnPageTotals() + ")";
    }
}

