/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.filter.visitor;

import com.google.common.base.Preconditions;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.filter.visitors.FilterExpressionNormalizationVisitor;
import com.yahoo.elide.core.request.Argument;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MatchesTemplateVisitor
implements FilterExpressionVisitor<Boolean> {
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{\\{(\\w+)\\}\\}");
    private FilterExpression expressionToMatch;
    private Map<String, Argument> arguments;

    public MatchesTemplateVisitor(FilterExpression expressionToMatch) {
        this.expressionToMatch = expressionToMatch;
        this.arguments = new HashMap<String, Argument>();
    }

    public Boolean visitPredicate(FilterPredicate filterPredicate) {
        return this.matches(this.expressionToMatch, (FilterExpression)filterPredicate);
    }

    public Boolean visitAndExpression(AndFilterExpression expression) {
        return this.matches(this.expressionToMatch, (FilterExpression)expression) || (Boolean)expression.getLeft().accept((FilterExpressionVisitor)this) != false || (Boolean)expression.getRight().accept((FilterExpressionVisitor)this) != false;
    }

    public Boolean visitOrExpression(OrFilterExpression expression) {
        return this.matches(this.expressionToMatch, (FilterExpression)expression);
    }

    public Boolean visitNotExpression(NotFilterExpression expression) {
        return this.matches(this.expressionToMatch, (FilterExpression)expression);
    }

    private boolean matches(FilterExpression a, FilterExpression b) {
        String value;
        Matcher matcher;
        if (!a.getClass().equals(b.getClass())) {
            return false;
        }
        if (a instanceof AndFilterExpression) {
            AndFilterExpression andA = (AndFilterExpression)a;
            AndFilterExpression andB = (AndFilterExpression)b;
            return this.matches(andA.getLeft(), andB.getLeft()) && this.matches(andA.getRight(), andB.getRight());
        }
        if (a instanceof OrFilterExpression) {
            OrFilterExpression orA = (OrFilterExpression)a;
            OrFilterExpression orB = (OrFilterExpression)b;
            return this.matches(orA.getLeft(), orB.getLeft()) && this.matches(orA.getRight(), orB.getRight());
        }
        if (a instanceof NotFilterExpression) {
            NotFilterExpression notA = (NotFilterExpression)a;
            NotFilterExpression notB = (NotFilterExpression)b;
            return this.matches(notA.getNegated(), notB.getNegated());
        }
        FilterPredicate predicateA = (FilterPredicate)a;
        FilterPredicate predicateB = (FilterPredicate)b;
        boolean valueMatches = predicateA.getValues().equals(predicateB.getValues());
        boolean operatorMatches = predicateA.getOperator().equals((Object)predicateB.getOperator());
        boolean pathMatches = this.pathMatches(predicateA.getPath(), predicateB.getPath());
        boolean usingTemplate = false;
        if (predicateA.getValues().size() == 1 && (usingTemplate = (matcher = TEMPLATE_PATTERN.matcher(value = predicateA.getValues().get(0).toString())).matches()) && pathMatches & operatorMatches) {
            String argumentName = matcher.group(1);
            this.arguments.put(argumentName, Argument.builder().name(argumentName).value(predicateB.getValues().size() == 1 ? predicateB.getValues().get(0) : predicateB.getValues()).build());
        }
        return operatorMatches && pathMatches && (valueMatches || usingTemplate);
    }

    private boolean pathMatches(Path a, Path b) {
        if (a.getPathElements().size() != b.getPathElements().size()) {
            return false;
        }
        for (int idx = 0; idx < a.getPathElements().size(); ++idx) {
            Path.PathElement aElement = (Path.PathElement)a.getPathElements().get(idx);
            Path.PathElement bElement = (Path.PathElement)b.getPathElements().get(idx);
            if (!aElement.getType().equals(bElement.getType())) {
                return false;
            }
            if (!aElement.getFieldName().equals(bElement.getFieldName())) {
                return false;
            }
            if (aElement.getArguments().size() <= 0 || aElement.getArguments().equals(bElement.getArguments())) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(FilterExpression templateFilter, FilterExpression clientFilter, Map<String, Argument> arguments) {
        MatchesTemplateVisitor templateVisitor;
        Preconditions.checkNotNull((Object)templateFilter);
        if (clientFilter == null) {
            return false;
        }
        FilterExpression normalizedTemplateFilter = (FilterExpression)templateFilter.accept((FilterExpressionVisitor)new FilterExpressionNormalizationVisitor());
        FilterExpression normalizedClientFilter = (FilterExpression)clientFilter.accept((FilterExpressionVisitor)new FilterExpressionNormalizationVisitor());
        boolean matches = (Boolean)normalizedClientFilter.accept((FilterExpressionVisitor)(templateVisitor = new MatchesTemplateVisitor(normalizedTemplateFilter)));
        if (matches) {
            arguments.putAll(templateVisitor.arguments);
        }
        return matches;
    }
}

