/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Headers {
    private static final Set<String> AUTHORIZATION_HEADER_NAMES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    private Headers() {
    }

    public static Map<String, List<String>> removeAuthorizationHeaders(Map<String, List<String>> headers) {
        boolean contains = false;
        for (String headerName : headers.keySet()) {
            if (!AUTHORIZATION_HEADER_NAMES.contains(headerName)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            return headers;
        }
        TreeMap<String, List<String>> requestHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        headers.entrySet().stream().forEach(entry -> {
            if (!AUTHORIZATION_HEADER_NAMES.contains(entry.getKey())) {
                requestHeaders.put((String)entry.getKey(), (List)entry.getValue());
            }
        });
        return requestHeaders;
    }

    static {
        AUTHORIZATION_HEADER_NAMES.addAll(Set.of("authorization", "proxy-authorization"));
    }
}

