/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.yahoo.elide.jsonapi.models.JsonApiError;
import java.io.IOException;
import java.util.Map;
import org.owasp.encoder.Encode;

public class JsonApiErrorSerializer
extends StdSerializer<JsonApiError> {
    private static final long serialVersionUID = 1L;

    public JsonApiErrorSerializer() {
        super(JsonApiError.class);
    }

    public void serialize(JsonApiError jsonApiError, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        Object t;
        jsonGenerator.writeStartObject();
        this.writeStringField(jsonGenerator, "id", jsonApiError.getId());
        if (jsonApiError.getLinks() != null) {
            jsonGenerator.writeObjectField("links", (Object)jsonApiError.getLinks());
        }
        this.writeStringField(jsonGenerator, "status", jsonApiError.getStatus());
        this.writeStringField(jsonGenerator, "code", jsonApiError.getCode());
        if (jsonApiError.getSource() != null) {
            jsonGenerator.writeObjectField("source", (Object)jsonApiError.getSource());
        }
        this.writeStringField(jsonGenerator, "title", jsonApiError.getTitle());
        if (jsonApiError.getDetail() != null && !jsonApiError.getDetail().isBlank()) {
            this.writeStringField(jsonGenerator, "detail", Encode.forHtml((String)jsonApiError.getDetail()));
        }
        if ((t = jsonApiError.getMeta()) instanceof Map) {
            Map map = (Map)t;
            if (!map.isEmpty()) {
                jsonGenerator.writeObjectField("meta", jsonApiError.getMeta());
            }
        } else if (jsonApiError.getMeta() != null) {
            jsonGenerator.writeObjectField("meta", jsonApiError.getMeta());
        }
        jsonGenerator.writeEndObject();
    }

    private void writeStringField(JsonGenerator jsonGenerator, String fieldName, String value) throws IOException {
        if (value != null && !value.isBlank()) {
            jsonGenerator.writeStringField(fieldName, value);
        }
    }
}

