/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.resources;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.request.route.BasicApiVersionValidator;
import com.yahoo.elide.core.request.route.FlexibleRouteResolver;
import com.yahoo.elide.core.request.route.NullRouteResolver;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.jsonapi.JsonApi;
import com.yahoo.elide.jsonapi.resources.SecurityContextUser;
import com.yahoo.elide.utils.HeaderProcessor;
import com.yahoo.elide.utils.ResourceUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

@Singleton
@Produces(value={"application/vnd.api+json"})
@Path(value="/")
public class JsonApiEndpoint {
    protected final Elide elide;
    protected final JsonApi jsonApi;
    protected final HeaderProcessor headerProcessor;
    protected final RouteResolver routeResolver;

    @Inject
    public JsonApiEndpoint(@Named(value="elide") Elide elide, Optional<RouteResolver> optionalRouteResolver) {
        this.elide = elide;
        this.jsonApi = new JsonApi(this.elide);
        this.headerProcessor = elide.getElideSettings().getHeaderProcessor();
        this.routeResolver = optionalRouteResolver.orElseGet(() -> {
            Set<String> apiVersions = elide.getElideSettings().getEntityDictionary().getApiVersions();
            if (apiVersions.size() == 1 && apiVersions.contains("")) {
                return new NullRouteResolver();
            }
            return new FlexibleRouteResolver(new BasicApiVersionValidator(), elide.getElideSettings()::getBaseUrl);
        });
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response post(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String jsonapiDocument) {
        String pathname;
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        String baseUrl = this.getBaseUrlEndpoint(uriInfo);
        Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname = path, requestHeaders, (Map<String, List<String>>)uriInfo.getQueryParameters());
        if ("/operations".equals(route.getPath()) || "operations".equals(route.getPath())) {
            return JsonApiEndpoint.build(this.jsonApi.operations(route, jsonapiDocument, user, UUID.randomUUID()));
        }
        return JsonApiEndpoint.build(this.jsonApi.post(route, jsonapiDocument, user, UUID.randomUUID()));
    }

    @GET
    @Path(value="{path:.*}")
    public Response get(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext) {
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        String baseUrl = this.getBaseUrlEndpoint(uriInfo);
        String pathname = path;
        Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeaders, (Map<String, List<String>>)uriInfo.getQueryParameters());
        return JsonApiEndpoint.build(this.jsonApi.get(route, user, UUID.randomUUID()));
    }

    @PATCH
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response patch(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String jsonapiDocument) {
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        String baseUrl = this.getBaseUrlEndpoint(uriInfo);
        String pathname = path;
        Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeaders, (Map<String, List<String>>)uriInfo.getQueryParameters());
        return JsonApiEndpoint.build(this.jsonApi.patch(route, jsonapiDocument, user, UUID.randomUUID()));
    }

    @DELETE
    @Path(value="{path:.*}")
    @Consumes(value={"application/vnd.api+json"})
    public Response delete(@PathParam(value="path") String path, @Context UriInfo uriInfo, @Context HttpHeaders headers, @Context SecurityContext securityContext, String jsonApiDocument) {
        Map<String, List<String>> requestHeaders = this.headerProcessor.process((Map<String, List<String>>)headers.getRequestHeaders());
        SecurityContextUser user = new SecurityContextUser(securityContext);
        String baseUrl = this.getBaseUrlEndpoint(uriInfo);
        String pathname = path;
        Route route = this.routeResolver.resolve("application/vnd.api+json", baseUrl, pathname, requestHeaders, (Map<String, List<String>>)uriInfo.getQueryParameters());
        return JsonApiEndpoint.build(this.jsonApi.delete(route, jsonApiDocument, user, UUID.randomUUID()));
    }

    private static Response build(ElideResponse<String> response) {
        return Response.status((int)response.getStatus()).entity((Object)response.getBody()).build();
    }

    protected String getBaseUrlEndpoint(UriInfo uriInfo) {
        String path;
        String baseUrl = this.elide.getElideSettings().getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ResourceUtils.resolveBaseUrl(uriInfo);
        }
        if ((path = uriInfo.getBaseUri().getPath()).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return baseUrl + path;
    }
}

