/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.jsonapi.JsonApiRequestScope;
import com.yahoo.elide.jsonapi.document.processors.IncludedProcessor;
import com.yahoo.elide.jsonapi.document.processors.PopulateMetaProcessor;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Relationship;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import com.yahoo.elide.jsonapi.parser.state.StateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RelationshipTerminalState
extends BaseState {
    private final PersistentResource record;
    private final RelationshipType relationshipType;
    private final String relationshipName;
    private final EntityProjection parentProjection;

    public RelationshipTerminalState(PersistentResource record, String relationshipName, EntityProjection parentProjection) {
        this.record = record;
        this.parentProjection = parentProjection;
        this.relationshipType = record.getRelationshipType(relationshipName);
        this.relationshipName = relationshipName;
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handleGet(StateContext state) {
        JsonApiDocument doc = new JsonApiDocument();
        JsonApiRequestScope requestScope = state.getRequestScope();
        Map<String, List<String>> queryParams = requestScope.getRoute().getParameters();
        Map<String, Relationship> relationships = this.record.toResource(this.parentProjection).getRelationships();
        if (relationships != null && relationships.containsKey(this.relationshipName)) {
            Relationship relationship = relationships.get(this.relationshipName);
            Data<Resource> data = relationship.getData();
            doc.setData(data);
            IncludedProcessor includedProcessor = new IncludedProcessor();
            includedProcessor.execute(doc, (RequestScope)requestScope, this.record, queryParams);
            return () -> Pair.of((Object)200, (Object)doc);
        }
        if (this.relationshipType.isToMany()) {
            doc.setData(new Data<Resource>(new ArrayList()));
        } else if (this.relationshipType.isToOne()) {
            doc.setData(new Data<Resource>((Resource)null));
        } else {
            throw new IllegalStateException("Failed to GET a relationship; relationship is neither toMany nor toOne");
        }
        PopulateMetaProcessor metaProcessor = new PopulateMetaProcessor();
        metaProcessor.execute(doc, (RequestScope)requestScope, this.record, queryParams);
        return () -> Pair.of((Object)200, (Object)doc);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handlePatch(StateContext state) {
        return this.handleRequest(state, this::patch);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handlePost(StateContext state) {
        return this.handleRequest(state, this::post);
    }

    @Override
    public Supplier<Pair<Integer, JsonApiDocument>> handleDelete(StateContext state) {
        return this.handleRequest(state, this::delete);
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleRequest(StateContext state, BiPredicate<Data<Resource>, RequestScope> handler) {
        Data<Resource> data = state.getJsonApiDocument().getData();
        handler.test(data, state.getRequestScope());
        return () -> Pair.of((Object)204, null);
    }

    private boolean patch(Data<Resource> data, RequestScope requestScope) {
        boolean isUpdated;
        if (this.relationshipType.isToMany() && data == null) {
            throw new InvalidEntityBodyException("Expected data but received null");
        }
        if (this.relationshipType.isToMany()) {
            if (data == null) {
                return false;
            }
            Collection<Resource> resources = data.get();
            if (resources == null) {
                return false;
            }
            isUpdated = !resources.isEmpty() ? this.record.updateRelation(this.relationshipName, new Relationship(null, new Data<Resource>(resources)).toPersistentResources(requestScope)) : this.record.clearRelation(this.relationshipName);
        } else if (this.relationshipType.isToOne()) {
            if (data != null) {
                Resource resource = data.getSingleValue();
                Relationship relationship = new Relationship(null, new Data<Resource>(resource));
                isUpdated = this.record.updateRelation(this.relationshipName, relationship.toPersistentResources(requestScope));
            } else {
                isUpdated = this.record.clearRelation(this.relationshipName);
            }
        } else {
            throw new IllegalStateException("Bad relationship type");
        }
        return isUpdated;
    }

    private boolean post(Data<Resource> data, RequestScope requestScope) {
        if (data == null) {
            throw new InvalidEntityBodyException("Expected data but received null");
        }
        Collection<Resource> resources = data.get();
        if (resources == null) {
            return false;
        }
        resources.stream().forEachOrdered(resource -> this.record.addRelation(this.relationshipName, resource.toPersistentResource(requestScope)));
        return true;
    }

    private boolean delete(Data<Resource> data, RequestScope requestScope) {
        if (data == null) {
            throw new InvalidEntityBodyException("Expected data but received null");
        }
        Collection<Resource> resources = data.get();
        if (CollectionUtils.isEmpty(resources)) {
            throw new ForbiddenAccessException(UpdatePermission.class);
        }
        resources.stream().forEachOrdered(resource -> this.record.removeRelation(this.relationshipName, resource.toPersistentResource(requestScope)));
        return true;
    }
}

