/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Ref;
import java.io.IOException;
import java.util.Locale;

@JsonPropertyOrder(value={"op", "ref", "href", "data", "meta"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Operation {
    private final OperationCode operationCode;
    private final Ref ref;
    private final String href;
    private final JsonNode data;
    private final Meta meta;

    @JsonProperty(value="op")
    public OperationCode getOperationCode() {
        return this.operationCode;
    }

    public Ref getRef() {
        return this.ref;
    }

    public String getHref() {
        return this.href;
    }

    public JsonNode getData() {
        return this.data;
    }

    public Meta getMeta() {
        return this.meta;
    }

    @JsonCreator
    public Operation(@JsonProperty(value="op") OperationCode operationCode, @JsonProperty(value="ref") Ref ref, @JsonProperty(value="href") String href, @JsonProperty(value="data") JsonNode data, @JsonProperty(value="meta") Meta meta) {
        this.operationCode = operationCode;
        this.ref = ref;
        this.href = href;
        this.data = data;
        this.meta = meta;
    }

    public static enum OperationCode {
        ADD(1, "add"),
        REMOVE(2, "remove"),
        UPDATE(3, "update");

        private final int id;
        private final String name;

        private OperationCode(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        @JsonCreator
        public static OperationCode fromName(String name) throws IOException {
            try {
                return name != null ? OperationCode.valueOf(name.toUpperCase(Locale.ENGLISH)) : null;
            }
            catch (RuntimeException e) {
                throw InvalidFormatException.from(null, (String)e.getMessage(), (Object)name, OperationCode.class);
            }
        }
    }
}

