/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.jsonapi.EntityProjectionMaker;
import com.yahoo.elide.jsonapi.JsonApiErrorContext;
import com.yahoo.elide.jsonapi.JsonApiExceptionHandler;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.JsonApiRequestScope;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import com.yahoo.elide.jsonapi.extensions.JsonApiAtomicOperations;
import com.yahoo.elide.jsonapi.extensions.JsonApiAtomicOperationsRequestScope;
import com.yahoo.elide.jsonapi.extensions.JsonApiJsonPatch;
import com.yahoo.elide.jsonapi.extensions.JsonApiJsonPatchRequestScope;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.parser.BaseVisitor;
import com.yahoo.elide.jsonapi.parser.DeleteVisitor;
import com.yahoo.elide.jsonapi.parser.GetVisitor;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import com.yahoo.elide.jsonapi.parser.PatchVisitor;
import com.yahoo.elide.jsonapi.parser.PostVisitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonApi.class);
    private final Elide elide;
    private final ElideSettings elideSettings;
    private final JsonApiSettings jsonApiSettings;
    private final DataStore dataStore;
    private final JsonApiMapper mapper;
    private final TransactionRegistry transactionRegistry;
    private final AuditLogger auditLogger;
    private final JsonApiExceptionHandler jsonApiExceptionHandler;
    private final boolean strictQueryParameters;
    public static final String MEDIA_TYPE = "application/vnd.api+json";

    public JsonApi(RefreshableElide refreshableElide) {
        this(refreshableElide.getElide());
    }

    public JsonApi(Elide elide) {
        this.elide = elide;
        this.jsonApiSettings = elide.getSettings(JsonApiSettings.class);
        this.strictQueryParameters = this.jsonApiSettings.isStrictQueryParameters();
        this.mapper = this.jsonApiSettings.getJsonApiMapper();
        this.dataStore = this.elide.getDataStore();
        this.elideSettings = this.elide.getElideSettings();
        this.transactionRegistry = this.elide.getTransactionRegistry();
        this.auditLogger = this.elide.getAuditLogger();
        this.jsonApiExceptionHandler = this.jsonApiSettings.getJsonApiExceptionHandler();
    }

    public ElideResponse<String> get(Route route, User opaqueUser, UUID requestId) {
        UUID requestUuid;
        UUID uUID = requestUuid = requestId != null ? requestId : UUID.randomUUID();
        if (this.strictQueryParameters) {
            try {
                this.verifyQueryParams(route.getParameters());
            }
            catch (BadRequestException e) {
                JsonApiErrorContext errorContext = JsonApiErrorContext.builder().mapper(this.mapper).verbose(false).build();
                ElideResponse<?> errorResponse = this.jsonApiExceptionHandler.handleException(e, errorContext);
                return this.toResponse(errorResponse.getStatus(), errorResponse.getBody());
            }
        }
        return this.handleRequest(true, opaqueUser, this.dataStore::beginReadTransaction, requestUuid, (tx, user) -> {
            JsonApiDocument jsonApiDoc = new JsonApiDocument();
            JsonApiRequestScope requestScope = JsonApiRequestScope.builder().route(route).dataStoreTransaction((DataStoreTransaction)tx).user((User)user).requestId(requestUuid).elideSettings(this.elideSettings).jsonApiDocument(jsonApiDoc).build();
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getEntityDictionary(), requestScope).parsePath(route.getPath()));
            GetVisitor visitor = new GetVisitor(requestScope);
            return this.visit(route.getPath(), requestScope, visitor);
        });
    }

    public ElideResponse<String> post(Route route, String jsonApiDocument, User opaqueUser, UUID requestId) {
        UUID requestUuid = requestId != null ? requestId : UUID.randomUUID();
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestUuid, (tx, user) -> {
            JsonApiDocument jsonApiDoc = this.mapper.readJsonApiDocument(jsonApiDocument);
            JsonApiRequestScope requestScope = JsonApiRequestScope.builder().route(route).dataStoreTransaction((DataStoreTransaction)tx).user((User)user).requestId(requestUuid).elideSettings(this.elideSettings).jsonApiDocument(jsonApiDoc).build();
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getEntityDictionary(), requestScope).parsePath(route.getPath()));
            PostVisitor visitor = new PostVisitor(requestScope);
            return this.visit(route.getPath(), requestScope, visitor);
        });
    }

    public ElideResponse<String> patch(Route route, String jsonApiDocument, User opaqueUser, UUID requestId) {
        UUID requestUuid = requestId != null ? requestId : UUID.randomUUID();
        String accept = JsonApi.getFirstHeaderValueOrEmpty(route, "accept");
        String contentType = JsonApi.getFirstHeaderValueOrEmpty(route, "content-type");
        Handler<DataStoreTransaction, User, HandlerResult> handler = JsonApiJsonPatch.isPatchExtension(contentType) && JsonApiJsonPatch.isPatchExtension(accept) ? (tx, user) -> {
            JsonApiJsonPatchRequestScope requestScope = new JsonApiJsonPatchRequestScope(route, (DataStoreTransaction)tx, (User)user, requestUuid, this.elideSettings);
            try {
                Supplier responder = JsonApiJsonPatch.processJsonPatch(this.dataStore, route.getPath(), jsonApiDocument, requestScope);
                return new HandlerResult((JsonApiRequestScope)requestScope, responder);
            }
            catch (RuntimeException e) {
                return new HandlerResult((JsonApiRequestScope)requestScope, e);
            }
        } : (tx, user) -> {
            JsonApiDocument jsonApiDoc = this.mapper.readJsonApiDocument(jsonApiDocument);
            JsonApiRequestScope requestScope = JsonApiRequestScope.builder().route(route).dataStoreTransaction((DataStoreTransaction)tx).user((User)user).requestId(requestUuid).elideSettings(this.elideSettings).jsonApiDocument(jsonApiDoc).build();
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getEntityDictionary(), requestScope).parsePath(route.getPath()));
            PatchVisitor visitor = new PatchVisitor(requestScope);
            return this.visit(route.getPath(), requestScope, visitor);
        };
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestUuid, handler);
    }

    public ElideResponse<String> delete(Route route, String jsonApiDocument, User opaqueUser, UUID requestId) {
        UUID requestUuid = requestId != null ? requestId : UUID.randomUUID();
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestUuid, (tx, user) -> {
            JsonApiDocument jsonApiDoc = StringUtils.isEmpty((CharSequence)jsonApiDocument) ? new JsonApiDocument() : this.mapper.readJsonApiDocument(jsonApiDocument);
            JsonApiRequestScope requestScope = JsonApiRequestScope.builder().route(route).dataStoreTransaction((DataStoreTransaction)tx).user((User)user).requestId(requestUuid).elideSettings(this.elideSettings).jsonApiDocument(jsonApiDoc).build();
            requestScope.setEntityProjection(new EntityProjectionMaker(this.elideSettings.getEntityDictionary(), requestScope).parsePath(route.getPath()));
            DeleteVisitor visitor = new DeleteVisitor(requestScope);
            return this.visit(route.getPath(), requestScope, visitor);
        });
    }

    public ElideResponse<String> operations(Route route, String jsonApiDocument, User opaqueUser, UUID requestId) {
        UUID requestUuid = requestId != null ? requestId : UUID.randomUUID();
        String accept = JsonApi.getFirstHeaderValueOrEmpty(route, "accept");
        String contentType = JsonApi.getFirstHeaderValueOrEmpty(route, "content-type");
        if (!JsonApiAtomicOperations.isAtomicOperationsExtension(contentType) || !JsonApiAtomicOperations.isAtomicOperationsExtension(accept)) {
            return ElideResponse.status(415).body("Unsupported Media Type");
        }
        Handler<DataStoreTransaction, User, HandlerResult> handler = (tx, user) -> {
            JsonApiAtomicOperationsRequestScope requestScope = new JsonApiAtomicOperationsRequestScope(route, (DataStoreTransaction)tx, (User)user, requestUuid, this.elideSettings);
            try {
                Supplier responder = JsonApiAtomicOperations.processAtomicOperations(this.dataStore, route.getPath(), jsonApiDocument, requestScope);
                return new HandlerResult((JsonApiRequestScope)requestScope, responder);
            }
            catch (RuntimeException e) {
                return new HandlerResult((JsonApiRequestScope)requestScope, e);
            }
        };
        return this.handleRequest(false, opaqueUser, this.dataStore::beginTransaction, requestUuid, handler);
    }

    public HandlerResult visit(String path, JsonApiRequestScope requestScope, BaseVisitor visitor) {
        try {
            Supplier responder = (Supplier)visitor.visit(JsonApiParser.parse(path));
            return new HandlerResult(requestScope, responder);
        }
        catch (RuntimeException e) {
            return new HandlerResult(requestScope, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> ElideResponse<String> handleRequest(boolean isReadOnly, User user, Supplier<DataStoreTransaction> transaction, UUID requestId, Handler<DataStoreTransaction, User, HandlerResult> handler) {
        JsonApiErrorContext errorContext = JsonApiErrorContext.builder().mapper(this.mapper).verbose(this.elideSettings.isVerboseErrors()).build();
        try {
            ElideResponse<String> elideResponse;
            block13: {
                DataStoreTransaction tx = transaction.get();
                try {
                    this.transactionRegistry.addRunningTransaction(requestId, tx);
                    HandlerResult result = handler.handle(tx, user);
                    JsonApiRequestScope requestScope = result.getRequestScope();
                    Supplier responder = result.getResponder();
                    tx.preCommit(requestScope);
                    requestScope.runQueuedPreSecurityTriggers();
                    requestScope.getPermissionExecutor().executeCommitChecks();
                    requestScope.runQueuedPreFlushTriggers();
                    if (!isReadOnly) {
                        requestScope.saveOrCreateObjects();
                    }
                    tx.flush(requestScope);
                    requestScope.runQueuedPreCommitTriggers();
                    ElideResponse<String> response = this.buildResponse(responder.get());
                    this.auditLogger.commit();
                    tx.commit(requestScope);
                    requestScope.runQueuedPostCommitTriggers();
                    if (log.isTraceEnabled()) {
                        requestScope.getPermissionExecutor().logCheckStats();
                    }
                    elideResponse = response;
                    if (tx == null) break block13;
                }
                catch (Throwable result) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                result.addSuppressed(throwable);
                            }
                        }
                        throw result;
                    }
                    catch (Throwable e) {
                        ElideResponse<?> errorResponse = this.jsonApiExceptionHandler.handleException(e, errorContext);
                        ElideResponse<String> elideResponse2 = this.toResponse(errorResponse.getStatus(), errorResponse.getBody());
                        return elideResponse2;
                    }
                }
                tx.close();
            }
            return elideResponse;
        }
        finally {
            this.transactionRegistry.removeRunningTransaction(requestId);
            this.auditLogger.clear();
        }
    }

    protected ElideResponse<String> toResponse(int status, Object body) {
        String result = null;
        if (body instanceof String) {
            String data;
            result = data = (String)body;
        } else {
            try {
                result = body != null ? this.mapper.writeJsonApiDocument(body) : null;
            }
            catch (JsonProcessingException e) {
                return ElideResponse.status(500).body(e.toString());
            }
        }
        return ElideResponse.status(status).body(result);
    }

    protected <T> ElideResponse<String> buildResponse(Pair<Integer, T> response) {
        Object responseNode = response.getRight();
        Integer responseCode = (Integer)response.getLeft();
        return this.toResponse(responseCode, responseNode);
    }

    private void verifyQueryParams(Map<String, List<String>> queryParams) {
        String undefinedKeys = queryParams.keySet().stream().filter(JsonApi::notAValidKey).collect(Collectors.joining(", "));
        if (!undefinedKeys.isEmpty()) {
            throw new BadRequestException("Found undefined keys in request: " + undefinedKeys);
        }
    }

    private static boolean notAValidKey(String key) {
        boolean validKey = key.equals("sort") || key.startsWith("filter") || key.startsWith("fields[") && key.endsWith("]") || key.startsWith("page[") || key.equals("include");
        return !validKey;
    }

    private static String getFirstHeaderValueOrEmpty(Route route, String headerName) {
        return route.getHeaders().getOrDefault(headerName, Collections.emptyList()).stream().findFirst().orElse("");
    }

    @Generated
    public Elide getElide() {
        return this.elide;
    }

    @FunctionalInterface
    public static interface Handler<DataStoreTransaction, User, HandlerResult> {
        public HandlerResult handle(DataStoreTransaction var1, User var2) throws IOException;
    }

    protected static class HandlerResult<T> {
        protected JsonApiRequestScope requestScope;
        protected Supplier<Pair<Integer, T>> result;
        protected RuntimeException cause;

        protected HandlerResult(JsonApiRequestScope requestScope, Supplier<Pair<Integer, T>> result) {
            this.requestScope = requestScope;
            this.result = result;
        }

        public HandlerResult(JsonApiRequestScope requestScope, RuntimeException cause) {
            this.requestScope = requestScope;
            this.cause = cause;
        }

        public Supplier<Pair<Integer, T>> getResponder() {
            if (this.cause != null) {
                throw this.cause;
            }
            return this.result;
        }

        public JsonApiRequestScope getRequestScope() {
            return this.requestScope;
        }
    }

    public static class AtomicOperations {
        public static final String MEDIA_TYPE = "application/vnd.api+json; ext=\"https://jsonapi.org/ext/atomic\"";

        private AtomicOperations() {
        }
    }

    public static class JsonPatch {
        public static final String MEDIA_TYPE = "application/vnd.api+json; ext=jsonpatch";

        private JsonPatch() {
        }
    }
}

