/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.type;

import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.FieldType;
import com.yahoo.elide.core.type.Type;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;

public class EntityFieldType
extends FieldType {
    Type<?> targetEntity = null;
    boolean toMany = false;

    public EntityFieldType(Field field) {
        super(field);
        Class entityType = null;
        if (field.isAnnotationPresent(ManyToMany.class)) {
            entityType = field.getAnnotation(ManyToMany.class).targetEntity();
            this.toMany = true;
        } else if (field.isAnnotationPresent(OneToMany.class)) {
            entityType = field.getAnnotation(OneToMany.class).targetEntity();
            this.toMany = true;
        } else if (field.isAnnotationPresent(OneToOne.class)) {
            entityType = field.getAnnotation(OneToOne.class).targetEntity();
        } else if (field.isAnnotationPresent(ManyToOne.class)) {
            entityType = field.getAnnotation(ManyToOne.class).targetEntity();
        }
        this.targetEntity = entityType == null || entityType.equals(Void.TYPE) ? null : ClassType.of(entityType);
    }

    @Override
    public Type<?> getParameterizedType(Type<?> parentType, Optional<Integer> index) {
        if (this.targetEntity != null) {
            return this.targetEntity;
        }
        return super.getParameterizedType(parentType, index);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityFieldType)) {
            return false;
        }
        EntityFieldType other = (EntityFieldType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.toMany != other.toMany) {
            return false;
        }
        Type<?> this$targetEntity = this.targetEntity;
        Type<?> other$targetEntity = other.targetEntity;
        return !(this$targetEntity == null ? other$targetEntity != null : !this$targetEntity.equals(other$targetEntity));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityFieldType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.toMany ? 79 : 97);
        Type<?> $targetEntity = this.targetEntity;
        result = result * 59 + ($targetEntity == null ? 43 : $targetEntity.hashCode());
        return result;
    }
}

