/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.permissions.expressions;

import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.security.permissions.expressions.ExpressionVisitor;
import lombok.Generated;

public class OrExpression
implements Expression {
    private final Expression left;
    private final Expression right;
    public static final OrExpression SUCCESSFUL_EXPRESSION = new OrExpression(Expression.Results.SUCCESS, null);
    public static final OrExpression FAILURE_EXPRESSION = new OrExpression(Expression.Results.FAILURE, null);

    public OrExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public ExpressionResult evaluate(Expression.EvaluationMode mode) {
        ExpressionResult rightResult;
        ExpressionResult leftResult = this.left.evaluate(mode);
        if (leftResult == ExpressionResult.PASS) {
            return ExpressionResult.PASS;
        }
        ExpressionResult expressionResult = rightResult = this.right == null ? leftResult : this.right.evaluate(mode);
        if (leftResult == ExpressionResult.FAIL && rightResult == ExpressionResult.FAIL) {
            return leftResult;
        }
        if (rightResult == ExpressionResult.PASS) {
            return ExpressionResult.PASS;
        }
        return ExpressionResult.DEFERRED;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitOrExpression(this);
    }

    public String toString() {
        if (this.right == null || this.right.equals(Expression.Results.FAILURE)) {
            return String.format("%s", this.left);
        }
        return String.format("(%s) OR (%s)", this.left, this.right);
    }

    @Generated
    public Expression getLeft() {
        return this.left;
    }

    @Generated
    public Expression getRight() {
        return this.right;
    }
}

