/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.permissions;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.checks.Check;
import com.yahoo.elide.core.security.permissions.ExpressionResultCache;
import com.yahoo.elide.core.security.permissions.PermissionCondition;
import com.yahoo.elide.core.security.permissions.expressions.AndExpression;
import com.yahoo.elide.core.security.permissions.expressions.AnyFieldExpression;
import com.yahoo.elide.core.security.permissions.expressions.CheckExpression;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.security.permissions.expressions.OrExpression;
import com.yahoo.elide.core.security.permissions.expressions.SpecificFieldExpression;
import com.yahoo.elide.core.security.visitors.PermissionExpressionNormalizationVisitor;
import com.yahoo.elide.core.security.visitors.PermissionExpressionVisitor;
import com.yahoo.elide.core.security.visitors.PermissionToFilterExpressionVisitor;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class PermissionExpressionBuilder {
    private final EntityDictionary entityDictionary;
    private final ExpressionResultCache cache;
    private static final Expression SUCCESSFUL_EXPRESSION = OrExpression.SUCCESSFUL_EXPRESSION;
    public static final Expression FAIL_EXPRESSION = OrExpression.FAILURE_EXPRESSION;

    public PermissionExpressionBuilder(ExpressionResultCache cache, EntityDictionary dictionary) {
        this.cache = cache;
        this.entityDictionary = dictionary;
    }

    public <A extends Annotation> Expression buildSpecificFieldExpressions(PersistentResource resource, Class<A> annotationClass, String field, ChangeSpec changeSpec) {
        Type resourceClass = resource.getResourceType();
        if (!this.entityDictionary.entityHasChecksForPermission(resourceClass, annotationClass)) {
            return SUCCESSFUL_EXPRESSION;
        }
        Function<Check, Expression> leafBuilderFn = this.leafBuilder(resource, changeSpec);
        Function<Function, Expression> buildExpressionFn = checkFn -> this.buildSpecificFieldExpression(PermissionCondition.create(annotationClass, resource, field, changeSpec), (Function<Check, Expression>)checkFn, true);
        return buildExpressionFn.apply(leafBuilderFn);
    }

    public <A extends Annotation> Expression buildAnyFieldExpressions(PersistentResource resource, Class<A> annotationClass, Set<String> requestedFields, ChangeSpec changeSpec) {
        Type resourceClass = resource.getResourceType();
        if (!this.entityDictionary.entityHasChecksForPermission(resourceClass, annotationClass)) {
            return SUCCESSFUL_EXPRESSION;
        }
        Function<Check, Expression> leafBuilderFn = this.leafBuilder(resource, changeSpec);
        Function<Function, Expression> expressionFunction = checkFn -> this.buildAnyFieldExpression(PermissionCondition.create(annotationClass, resource, null, changeSpec), (Function<Check, Expression>)checkFn, requestedFields, resource.getRequestScope());
        return expressionFunction.apply(leafBuilderFn);
    }

    public <A extends Annotation> Expression buildUserCheckFieldExpressions(Type<?> resourceClass, RequestScope scope, Class<A> annotationClass, String field) {
        return this.buildUserCheckFieldExpressions(resourceClass, scope, annotationClass, field, true);
    }

    public <A extends Annotation> Expression buildUserCheckFieldExpressions(Type<?> resourceClass, RequestScope scope, Class<A> annotationClass, String field, boolean includeEntityPermission) {
        if (!this.entityDictionary.entityHasChecksForPermission(resourceClass, annotationClass)) {
            return SUCCESSFUL_EXPRESSION;
        }
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, null, scope, null, this.cache);
        return this.buildSpecificFieldExpression(new PermissionCondition(annotationClass, resourceClass, field), leafBuilderFn, includeEntityPermission);
    }

    public <A extends Annotation> Expression buildUserCheckAnyExpression(Type<?> resourceClass, Class<A> annotationClass, Set<String> requestedFields, RequestScope requestScope) {
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, null, requestScope, null, this.cache);
        return this.buildAnyFieldExpression(new PermissionCondition(annotationClass, resourceClass), leafBuilderFn, requestedFields, requestScope);
    }

    public <A extends Annotation> Expression buildUserCheckAnyFieldOnlyExpression(Type<?> resourceClass, Class<A> annotationClass, Set<String> requestedFields, RequestScope requestScope) {
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, null, requestScope, null, this.cache);
        return this.buildAnyFieldOnlyExpression(new PermissionCondition(annotationClass, resourceClass), leafBuilderFn, requestedFields);
    }

    public <A extends Annotation> Expression buildUserCheckEntityAndAnyFieldExpression(Type<?> resourceClass, Class<A> annotationClass, Set<String> requestedFields, RequestScope scope) {
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, null, scope, null, this.cache);
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(resourceClass, annotationClass);
        Expression entityExpression = this.normalizedExpressionFromParseTree(classPermissions, leafBuilderFn);
        Expression anyFieldExpression = this.buildAnyFieldOnlyExpression(new PermissionCondition(annotationClass, resourceClass), leafBuilderFn, requestedFields);
        if (entityExpression == null) {
            return anyFieldExpression;
        }
        return new AndExpression(entityExpression, anyFieldExpression);
    }

    private Expression buildSpecificFieldExpression(PermissionCondition condition, Function<Check, Expression> checkFn, boolean includeEntityPermission) {
        Type<?> resourceClass = condition.getEntityClass();
        Class<? extends Annotation> annotationClass = condition.getPermission();
        String field = condition.getField().orElse(null);
        ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(resourceClass, field, annotationClass);
        if (includeEntityPermission) {
            ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(resourceClass, annotationClass);
            return new SpecificFieldExpression(condition, this.normalizedExpressionFromParseTree(classPermissions, checkFn), this.normalizedExpressionFromParseTree(fieldPermissions, checkFn));
        }
        return new SpecificFieldExpression(condition, null, this.normalizedExpressionFromParseTree(fieldPermissions, checkFn));
    }

    private Expression buildAnyFieldExpression(PermissionCondition condition, Function<Check, Expression> checkFn, Set<String> requestedFields, RequestScope scope) {
        Type<?> resourceClass = condition.getEntityClass();
        Class<? extends Annotation> annotationClass = condition.getPermission();
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(resourceClass, annotationClass);
        Expression entityExpression = this.normalizedExpressionFromParseTree(classPermissions, checkFn);
        OrExpression allFieldsExpression = new OrExpression(Expression.Results.FAILURE, null);
        List<String> fields = this.entityDictionary.getAllExposedFields(resourceClass);
        boolean entityExpressionUsed = false;
        boolean fieldExpressionUsed = false;
        for (String field : fields) {
            if (requestedFields != null && !requestedFields.contains(field)) continue;
            ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(resourceClass, field, annotationClass);
            Expression fieldExpression = this.normalizedExpressionFromParseTree(fieldPermissions, checkFn);
            if (fieldExpression == null) {
                if (entityExpressionUsed) continue;
                if (entityExpression == null) {
                    return SUCCESSFUL_EXPRESSION;
                }
                fieldExpression = entityExpression;
                entityExpressionUsed = true;
            } else {
                fieldExpressionUsed = true;
            }
            allFieldsExpression = new OrExpression(allFieldsExpression, fieldExpression);
        }
        if (!fieldExpressionUsed) {
            if (entityExpression == null) {
                return SUCCESSFUL_EXPRESSION;
            }
            return new AnyFieldExpression(condition, entityExpression);
        }
        return new AnyFieldExpression(condition, allFieldsExpression);
    }

    private Expression buildAnyFieldOnlyExpression(PermissionCondition condition, Function<Check, Expression> checkFn, Set<String> requestedFields) {
        Type<?> resourceClass = condition.getEntityClass();
        Class<? extends Annotation> annotationClass = condition.getPermission();
        OrExpression allFieldsExpression = new OrExpression(Expression.Results.FAILURE, null);
        List<String> fields = this.entityDictionary.getAllExposedFields(resourceClass);
        boolean fieldExpressionUsed = false;
        for (String field : fields) {
            if (requestedFields != null && !requestedFields.contains(field)) continue;
            ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(resourceClass, field, annotationClass);
            Expression fieldExpression = this.normalizedExpressionFromParseTree(fieldPermissions, checkFn);
            if (fieldExpression == null) {
                return SUCCESSFUL_EXPRESSION;
            }
            fieldExpressionUsed = true;
            allFieldsExpression = new OrExpression(allFieldsExpression, fieldExpression);
        }
        if (!fieldExpressionUsed) {
            return SUCCESSFUL_EXPRESSION;
        }
        return new AnyFieldExpression(condition, allFieldsExpression);
    }

    public FilterExpression buildAnyFieldFilterExpression(Type<?> forType, RequestScope requestScope, Set<String> requestedFields) {
        Class<ReadPermission> annotationClass = ReadPermission.class;
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(forType, annotationClass);
        FilterExpression entityFilter = this.filterExpressionFromParseTree(classPermissions, forType, requestScope);
        if (entityFilter == PermissionToFilterExpressionVisitor.FALSE_USER_CHECK_EXPRESSION || entityFilter == PermissionToFilterExpressionVisitor.NO_EVALUATION_EXPRESSION || entityFilter == PermissionToFilterExpressionVisitor.TRUE_USER_CHECK_EXPRESSION) {
            entityFilter = null;
        }
        FilterExpression allFieldsFilterExpression = entityFilter;
        List fields = this.entityDictionary.getAllExposedFields(forType).stream().filter(field -> requestedFields == null || requestedFields.contains(field)).collect(Collectors.toList());
        for (String field2 : fields) {
            ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(forType, field2, annotationClass);
            FilterExpression fieldExpression = this.filterExpressionFromParseTree(fieldPermissions, forType, requestScope);
            if (fieldExpression == null && entityFilter == null) {
                return null;
            }
            if (fieldExpression == null || fieldExpression == PermissionToFilterExpressionVisitor.FALSE_USER_CHECK_EXPRESSION) continue;
            if (fieldExpression == PermissionToFilterExpressionVisitor.NO_EVALUATION_EXPRESSION || fieldExpression == PermissionToFilterExpressionVisitor.TRUE_USER_CHECK_EXPRESSION) {
                return null;
            }
            if (allFieldsFilterExpression != null) {
                allFieldsFilterExpression = new OrFilterExpression(allFieldsFilterExpression, fieldExpression);
                continue;
            }
            allFieldsFilterExpression = fieldExpression;
        }
        return allFieldsFilterExpression;
    }

    public FilterExpression buildEntityFilterExpression(Type<?> forType, RequestScope requestScope) {
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(forType, ReadPermission.class);
        FilterExpression entityFilter = this.filterExpressionFromParseTree(classPermissions, forType, requestScope);
        if (entityFilter == PermissionToFilterExpressionVisitor.FALSE_USER_CHECK_EXPRESSION || entityFilter == PermissionToFilterExpressionVisitor.NO_EVALUATION_EXPRESSION || entityFilter == PermissionToFilterExpressionVisitor.TRUE_USER_CHECK_EXPRESSION) {
            return null;
        }
        return entityFilter;
    }

    private Expression normalizedExpressionFromParseTree(ParseTree permissions, Function<Check, Expression> checkFn) {
        if (permissions == null) {
            return null;
        }
        return ((Expression)permissions.accept((ParseTreeVisitor)new PermissionExpressionVisitor(this.entityDictionary, checkFn))).accept(new PermissionExpressionNormalizationVisitor());
    }

    private FilterExpression filterExpressionFromParseTree(ParseTree permissions, Type type, RequestScope scope) {
        if (permissions == null) {
            return null;
        }
        Function<Check, Expression> checkFn = check -> new CheckExpression((Check)check, null, scope, null, this.cache);
        return this.normalizedExpressionFromParseTree(permissions, checkFn).accept(new PermissionToFilterExpressionVisitor(this.entityDictionary, scope, type));
    }

    private Function<Check, Expression> leafBuilder(PersistentResource resource, ChangeSpec changeSpec) {
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, resource, resource.getRequestScope(), changeSpec, this.cache);
        return leafBuilderFn;
    }
}

