/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.obfuscation;

import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.security.obfuscation.IdObfuscator;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;

public class FunctionIdObfuscator
implements IdObfuscator {
    private final Function<byte[], byte[]> obfuscationFunction;
    private final Function<byte[], byte[]> deobfuscationFunction;

    public FunctionIdObfuscator(Function<byte[], byte[]> obfuscationFunction, Function<byte[], byte[]> deobfuscationFunction) {
        this.obfuscationFunction = obfuscationFunction;
        this.deobfuscationFunction = deobfuscationFunction;
    }

    @Override
    public String obfuscate(Object id) {
        byte[] result;
        if (id instanceof Long) {
            Long value = (Long)id;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(value);
            result = this.obfuscationFunction.apply(buffer.array());
        } else if (id instanceof Integer) {
            Integer value = (Integer)id;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(value);
            result = this.obfuscationFunction.apply(buffer.array());
        } else if (id instanceof String) {
            String value = (String)id;
            result = this.obfuscationFunction.apply(value.getBytes(StandardCharsets.UTF_8));
        } else {
            throw new InvalidValueException((Object)"id");
        }
        return Base64.getUrlEncoder().withoutPadding().encodeToString(result);
    }

    @Override
    public <T> T deobfuscate(String obfuscatedId, Type<?> type) {
        try {
            byte[] value = Base64.getUrlDecoder().decode(obfuscatedId);
            byte[] result = this.deobfuscationFunction.apply(value);
            if (ClassType.LONG_TYPE.equals(type) || ClassType.PRIMITIVE_LONG_TYPE.equals(type)) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.put(result);
                buffer.flip();
                return (T)Long.valueOf(buffer.getLong());
            }
            if (ClassType.INTEGER_TYPE.equals(type) || ClassType.PRIMITIVE_INTEGER_TYPE.equals(type)) {
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.put(result);
                buffer.flip();
                return (T)Integer.valueOf(buffer.getInt());
            }
            if (ClassType.STRING_TYPE.equals(type)) {
                return (T)new String(result, StandardCharsets.UTF_8);
            }
            throw new InvalidValueException((Object)"id");
        }
        catch (RuntimeException e) {
            throw new InvalidValueException((Object)"id");
        }
    }
}

