/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request.route;

import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import java.util.List;
import java.util.Map;

public class PathRouteResolver
implements RouteResolver {
    private final String versionPrefix;
    private final ApiVersionValidator apiVersionValidator;

    public PathRouteResolver(String versionPrefix, ApiVersionValidator apiVersionValidator) {
        this.versionPrefix = versionPrefix;
        this.apiVersionValidator = apiVersionValidator;
    }

    @Override
    public Route resolve(String mediaType, String baseUrl, String path, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        Object baseRoute = baseUrl == null ? "" : baseUrl;
        String route = path;
        String apiVersion = "";
        String apiVersionString = "";
        int versionStart = -1;
        int versionEnd = -1;
        int pathStart = -1;
        int pathEnd = -1;
        int find = path.indexOf(47, 0);
        if (find != -1) {
            if (find == 0) {
                versionStart = 1;
                int findEnd = path.indexOf(47, 1);
                if (findEnd != -1) {
                    versionEnd = findEnd;
                    pathStart = findEnd;
                    pathEnd = path.length();
                } else {
                    versionEnd = path.length();
                }
            } else {
                versionStart = 0;
                versionEnd = find;
                pathStart = find;
                pathEnd = path.length();
            }
        } else {
            versionStart = 0;
            versionEnd = path.length();
        }
        if (versionStart != -1 && versionEnd != -1) {
            apiVersionString = apiVersion = path.substring(versionStart, versionEnd);
        }
        if (!apiVersion.isEmpty() && !this.versionPrefix.isEmpty() && apiVersion.startsWith(this.versionPrefix)) {
            apiVersion = apiVersion.substring(this.versionPrefix.length());
        }
        if (!apiVersion.isEmpty() && !this.apiVersionValidator.isValidApiVersion(apiVersion)) {
            apiVersion = "";
            pathStart = 0;
            pathEnd = path.length();
            apiVersionString = "";
        }
        if ((route = pathStart != -1 && pathEnd != -1 ? path.substring(pathStart, pathEnd) : "").length() > 0 && route.charAt(0) == '/') {
            route = route.substring(1);
        }
        baseRoute = ((String)baseRoute).length() > 0 && ((String)baseRoute).charAt(((String)baseRoute).length() - 1) == '/' ? (String)baseRoute + apiVersionString : (String)baseRoute + "/" + apiVersionString;
        return Route.builder().apiVersion(apiVersion).baseUrl((String)baseRoute).path(route).headers(headers).parameters(parameters).build();
    }
}

