/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request.route;

import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.MediaTypeParameterRouteResolver;
import com.yahoo.elide.core.request.route.UriPrefixSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MediaTypeProfileRouteResolver
extends MediaTypeParameterRouteResolver {
    private static final String MEDIA_TYPE_PARAMETER_PROFILE = "profile=";
    private final String versionPrefix;
    private final UriPrefixSupplier uriPrefixSupplier;
    private final ApiVersionValidator apiVersionValidator;

    public MediaTypeProfileRouteResolver(String versionPrefix, ApiVersionValidator apiVersionValidator, UriPrefixSupplier uriPrefixSupplier) {
        super(null);
        this.versionPrefix = versionPrefix;
        this.uriPrefixSupplier = uriPrefixSupplier;
        this.apiVersionValidator = apiVersionValidator;
    }

    @Override
    protected String fromMediaTypeParameter(String parameter) {
        if (parameter.startsWith(MEDIA_TYPE_PARAMETER_PROFILE)) {
            Profile profile = this.parseProfile(parameter.substring(MEDIA_TYPE_PARAMETER_PROFILE.length()));
            return this.processProfile(profile);
        }
        return "";
    }

    public String processProfile(Profile profile) {
        String uriPrefix = this.uriPrefixSupplier.getUriPrefix();
        for (String value : profile.getValues()) {
            String version;
            int start;
            if (!value.startsWith(uriPrefix) || (start = value.lastIndexOf("/")) == -1 || value.length() <= start + 1 || !(version = value.substring(start + 1)).startsWith(this.versionPrefix) || !this.apiVersionValidator.isValidApiVersion(version = version.substring(this.versionPrefix.length()))) continue;
            return version;
        }
        return "";
    }

    public Profile parseProfile(String parameter) {
        if (parameter.charAt(0) == '\"' && parameter.charAt(parameter.length() - 1) == '\"') {
            String list = parameter.substring(1, parameter.length() - 1);
            String[] items = list.split(" ");
            ArrayList<String> values = new ArrayList<String>(items.length);
            Collections.addAll(values, items);
            return new Profile(values);
        }
        return new Profile(Collections.singletonList(parameter));
    }

    public static final class Profile {
        private List<String> values;

        public Profile(List<String> values) {
            this.values = values;
        }

        public List<String> getValues() {
            return this.values;
        }
    }
}

