/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request.route;

import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HeaderRouteResolver
implements RouteResolver {
    private final String[] apiVersionHeaderNames;

    public HeaderRouteResolver(String ... apiVersionHeaderNames) {
        this.apiVersionHeaderNames = apiVersionHeaderNames;
        for (int x = 0; x < apiVersionHeaderNames.length; ++x) {
            this.apiVersionHeaderNames[x] = this.apiVersionHeaderNames[x].toLowerCase(Locale.ENGLISH);
        }
    }

    @Override
    public Route resolve(String mediaType, String baseUrl, String path, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        for (String apiVersionHeaderName : this.apiVersionHeaderNames) {
            String apiVersion;
            if (headers == null || headers.get(apiVersionHeaderName) == null || (apiVersion = headers.get(apiVersionHeaderName).get(0)) == null) continue;
            return Route.builder().apiVersion(apiVersion).baseUrl(baseUrl).path(path).headers(headers).parameters(parameters).build();
        }
        return Route.builder().apiVersion("").baseUrl(baseUrl).path(path).headers(headers).parameters(parameters).build();
    }
}

