/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request.route;

import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DelegatingRouteResolver
implements RouteResolver {
    private final List<RouteResolver> routeResolvers;

    public DelegatingRouteResolver(RouteResolver ... routeResolver) {
        this(Arrays.asList(routeResolver));
    }

    public DelegatingRouteResolver(List<RouteResolver> routeResolvers) {
        this.routeResolvers = routeResolvers;
    }

    @Override
    public Route resolve(String mediaType, String baseUrl, String path, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        for (RouteResolver routeResolver : this.routeResolvers) {
            Route route = routeResolver.resolve(mediaType, baseUrl, path, headers, parameters);
            if ("".equals(route.getApiVersion())) continue;
            return route;
        }
        return Route.builder().apiVersion("").baseUrl(baseUrl).path(path).headers(headers).parameters(parameters).build();
    }
}

